/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

public class LicenseFileErrorException
extends Exception {
    public static final int INVALID_LICENSE = 1000;
    public static final int LICENSE_IO_ERROR = 1001;
    public static final int USER_CHANGED_TIME = 1002;
    public static final int FAIL_TO_GETSOFTCODE = 1003;
    public static final int LICENSEFILE_EXIST = 1004;
    public static final int LICENSEFILE_LIBKEY_ERROR = 1005;
    public static final int DULPLICATE_TRIAL_LICENES = 1006;
    public static final int DULPLICATE_NORMAL_LICENES = 1007;
    public static final int PRODUCTION_VERSION_NOT_MATCH = 1008;
    public static final int PRODUCTION_SECTION_NOT_MATCH = 1009;
    public static final int REGIST_USERS_CONVERT_FAIL = 1010;
    public static final int BIM_LICENSE_CANNOT_IMPORT = 1011;
    public static final int IP_ADDRESS_ERROR = 1021;
    private int errorCode;
    private String errorSource;
    private Throwable sourceObject;

    public LicenseFileErrorException(int pCode) {
        this.errorCode = pCode;
    }

    public LicenseFileErrorException(int pCode, String pSource) {
        this.errorCode = pCode;
        this.errorSource = pSource;
    }

    public LicenseFileErrorException(int pCode, Throwable t) {
        super(t.getMessage());
        this.errorCode = pCode;
        this.sourceObject = t;
    }

    public LicenseFileErrorException(int pCode, String pSource, Throwable t) {
        super(t.getMessage());
        this.errorCode = pCode;
        this.errorSource = pSource;
        this.sourceObject = t;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorSource() {
        return this.errorSource;
    }

    @Override
    public String getMessage() {
        String msg = null;
        switch (this.errorCode) {
            case 1000: {
                msg = "error occured when verify " + this.errorSource;
                break;
            }
            case 1001: {
                msg = "I/O error where read/write license file.";
                break;
            }
            case 1002: {
                msg = "User can't modify the server machine time,current time can't be grearer than lastruntime.";
                break;
            }
            case 1003: {
                msg = "get software code failed";
                break;
            }
            case 1004: {
                msg = "the same licenseFile existed";
                break;
            }
            case 1005: {
                msg = "Licensefile can't match this machine";
                break;
            }
            case 1006: {
                msg = "Can't have multiple Trial Licensefile at one machine ";
                break;
            }
            case 1007: {
                msg = "Can't have multiple Normal Licensefile at one machine ";
                break;
            }
            case 1008: {
                msg = "License file version does not match current EAS version";
                break;
            }
            case 1009: {
                msg = this.errorSource;
                break;
            }
            case 1010: {
                msg = "convert license registUsers fail";
                break;
            }
            case 1011: {
                msg = "EAS BIM license can not import";
                break;
            }
            case 1021: {
                msg = "Server IP address error";
                break;
            }
            default: {
                msg = "unknown error!";
            }
        }
        if (this.sourceObject != null) {
            msg = msg + "\n Caused by " + this.sourceObject.getMessage();
        }
        return msg;
    }
}

