/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.license.old.AESCryptoAlgorithm;
import kd.ebg.egf.common.license.old.CryptoAlgorithm;
import kd.ebg.egf.common.license.old.License;
import kd.ebg.egf.common.license.old.LicenseFileErrorException;
import kd.ebg.egf.common.license.old.LicenseImpl;
import kd.ebg.egf.common.license.old.ModuleLicenseInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.crypto.DigestUtil;

public class LicenseManager {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(LicenseManager.class);
    private static final String CIPHER = "PELDJ3MSE9WNT6KEDQOMGHG7LDJHVFZX";
    private static final String softwareName = "\"kingdee eas nextcloud V1.0\"";
    private static CryptoAlgorithm aes = new AESCryptoAlgorithm();
    public static final String MODULE_NAME = "QUERY_PAY";

    public static License getLicense(byte[] bytes) throws LicenseFileErrorException {
        try {
            LicenseImpl license = new LicenseImpl(new ByteArrayInputStream(bytes));
            license.setCipher(CIPHER);
            license.setSoftwareName(softwareName);
            ((License)license).readLicense();
            if (Objects.nonNull(license)) {
                List moduleDetails = license.getModuleDetails();
                if (moduleDetails == null || moduleDetails.isEmpty()) {
                    log.info("license \u91cc\u9762\u6ca1\u6709\u6a21\u5757\u4fe1\u606f");
                    license = null;
                } else {
                    boolean hasQueryPayModule = false;
                    for (ModuleLicenseInfo info : moduleDetails) {
                        if (!MODULE_NAME.equals(info.getModuleName())) continue;
                        hasQueryPayModule = true;
                        break;
                    }
                    if (!hasQueryPayModule) {
                        log.info("license \u91cc\u9762\u6ca1\u6709\u94f6\u4f01\u6a21\u5757");
                        license = null;
                    }
                }
            }
            return license;
        }
        catch (LicenseFileErrorException e) {
            log.error("", e);
            throw e;
        }
    }

    public static String getCustomerFeatureCode(String customerNo) {
        String base64 = Base64.getEncoder().encodeToString(aes.encrypt(customerNo.getBytes(Charset.forName("UTF-8"))));
        return DigestUtil.md5Hex(base64).toUpperCase();
    }
}

