/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.log;

import java.util.List;
import kd.ebg.egf.common.constant.LogFilerType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.log.LogFilterConfigService;
import kd.ebg.egf.common.log.LogFilterConfig;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class LogFilterUtil {
    public static String BASE64 = "base64";
    public static String OMIT = "******";

    public static String getSendResult(String sendMsg) {
        if (StringUtils.isEmpty(sendMsg)) {
            return sendMsg;
        }
        try {
            EBContext context = EBContext.getContext();
            if (context == null) {
                return sendMsg;
            }
            String bankVersion = context.getBankVersionID();
            if (StringUtils.isEmpty(bankVersion)) {
                return sendMsg;
            }
            List<LogFilterConfig> keyWords = LogFilterConfigService.getInstance().getKeyWords(bankVersion);
            if (keyWords == null || keyWords.size() == 0) {
                return sendMsg;
            }
            for (LogFilterConfig logFilterConfig : keyWords) {
                if (LogFilerType.TEXT.getType().equals(logFilterConfig.getWordType())) {
                    if (!BASE64.equalsIgnoreCase(logFilterConfig.getWordKey()) || !LogFilterUtil.isBase64String(sendMsg)) continue;
                    sendMsg = OMIT;
                    continue;
                }
                if (LogFilerType.KV.getType().equals(logFilterConfig.getWordType())) {
                    sendMsg = LogFilterUtil.getKVLog(sendMsg, logFilterConfig.getWordKey());
                    continue;
                }
                if (LogFilerType.XML.getType().equals(logFilterConfig.getWordType())) {
                    sendMsg = LogFilterUtil.getXmlLog(sendMsg, logFilterConfig.getWordKey());
                    continue;
                }
                if (!LogFilerType.JSON.getType().equals(logFilterConfig.getWordType())) continue;
                sendMsg = LogFilterUtil.getJsonLog(sendMsg, logFilterConfig.getWordKey());
            }
            return sendMsg;
        }
        catch (Exception e) {
            return sendMsg;
        }
    }

    public static boolean isBase64String(String sendMsg) {
        try {
            sendMsg = sendMsg.replaceAll("[\n\r]", "").trim();
            byte[] bytes = Base64.decodeBase64((String)sendMsg);
            String checkBase64String = Base64.encodeBase64String((byte[])bytes);
            return checkBase64String.equals(sendMsg);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getXmlLog(String sendMsg, String bankKey) {
        int startNo = sendMsg.indexOf("<" + bankKey + ">");
        int endNo = sendMsg.indexOf("</" + bankKey + ">");
        if (startNo == -1 || endNo == -1) {
            return sendMsg;
        }
        String target = sendMsg.substring(startNo, endNo);
        if (StringUtils.isEmpty(target)) {
            return sendMsg;
        }
        String regix = "<" + bankKey + ">" + OMIT;
        sendMsg = sendMsg.replace(target, regix);
        return sendMsg;
    }

    public static String getJsonLog(String sendMsg, String bankKey) {
        String target = "\"" + bankKey + "\":";
        int startNo = sendMsg.indexOf(target);
        if (startNo == -1) {
            return sendMsg;
        }
        String temp = sendMsg.substring(startNo + target.length());
        int startNoContent = temp.indexOf("\"");
        if (startNoContent == -1) {
            return sendMsg;
        }
        String[] splits = temp.split("\"");
        StringBuilder againTarget = new StringBuilder().append(target).append(splits[0]).append("\"");
        startNo = sendMsg.indexOf(target = againTarget.toString());
        if (startNo == -1) {
            return sendMsg;
        }
        temp = sendMsg.substring(startNo + target.length());
        startNoContent = temp.indexOf("\"");
        temp = temp.substring(0, startNoContent);
        target = target + temp;
        sendMsg = sendMsg.replace(target, "\"" + bankKey + "\":\"" + OMIT);
        return sendMsg;
    }

    public static String getKVLog(String sendMsg, String bankKey) {
        String matchKey = bankKey + "=";
        int index = sendMsg.indexOf(matchKey);
        String subContent = sendMsg.substring(index + matchKey.length());
        int splitIndex = subContent.indexOf("&");
        if (index != -1) {
            String subMsg = sendMsg.substring(0, index + matchKey.length()) + OMIT;
            if (splitIndex != -1) {
                return subMsg + sendMsg.substring(index + matchKey.length() + splitIndex);
            }
            return subMsg;
        }
        return sendMsg;
    }

    public static void main(String[] args) {
        String str = "lle=123&reqData=Ux5pHTe1R61wWFZCnz4I/GDe7UHGo/9MaUj6albMY9b/fJE/xKCu2tHhvIdD2SizQUQv+0YhB+U/O501LCiEa/WHOfNwiyWVPXL43KxoIW59W+eoF8dIfSpCp/Gbc4C1YS8IIbMNA3RAg5+7vHAQbswLs1F+utsenAu7MN9DgsQ6dw0lzUPnHTsxL+G3JiFIvUlObAWQqM7C4bxT5AOpAiRrPAqGHnRy3UYzJyPbwRqdsWDxsODr/bMa1SIxq1u2HNKRBQi4b30pExtgzK+WxY+27f/UM9sz1e8inC6teIpSascbmndBd6808j6IBHZAFAkz1BNynYp/u9Y9m1vwtf0QhLfzQeM/ADLdRdHhFdq3PcYmFWYgwJIlWwzP2k7lUL47eARJgEToDIr4HrGzYrMKpFWkMltHg8W8xcN0BtxQ5ftLMB0edxkQ8Xc0NgNKCT2eyLYS5ImlNJ+YxMWxq5KClSEy+vfqEp8KH1yjpsAis0GhOAzo+qlUPPWUwV2x/AjK9js+B1sIlI3VxG1vUntWsU6aV5Hbz0LG7/iLj9Wb68ZDlPO1x8xjvbuczwksKN69wCpQU49nAbwlkw6KhgYV2wNa8BnYsbgK6+/J1tripWHcpGzk2fsoQes6izcLGUFVUETDoDaTLM8G03d3E8sh3dBRDMa8I2wNMha7a8fGKjH5rbe7gLxA8Ws0IBFQy9zDJDDrnw1jWn7fZwjsnvR1Bs/+By46+4brpICasz0+fyVNXPpHMdCb9pIoktDqIPAlJhGEafYm/TRWpaJAf8uZuVg/Oq81pjFss1PPxp88jNRjKDvNHQqYDU08b4pOtVNtkLsP7YHOAvltyIax2ilsXbD1M5zG06ZUp8Cf11JnIy7xR+n4R7OfDCoKYnF28yknjIDb7imUxrCZSjqWdYEugNLaIIGyP6hQTKKUhHBuzKhi3qT7eJ910jIbUpIBUbqJl4Muz01pgChY+HhkMA5KKPlx0ry2SP8hv17Jz3A=&key=1";
        System.out.println(LogFilterUtil.getKVLog(str, "reqData"));
    }
}

