/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.model.bank.login;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import javax.persistence.Transient;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankLoginConfig {
    private String id;
    private BankLoginConfigKey key;
    private String bankConfigValue;
    private List<String> sourceValues;
    private List<String> sourceNames;
    private List<MultiLangEnumBridge> mlSourceNames;
    private String bankConfigName;
    private MultiLangEnumBridge mlBankConfigName;
    private Boolean readOnly;
    private Boolean isHidden;
    private Boolean nullable;
    private String desc;
    private MultiLangEnumBridge mlDesc;
    private List<MultiLangEnumBridge> mlDescs;
    private String type;
    private Integer maxLength;
    private Integer minValueNum;
    private Integer maxValueNum;
    @Transient
    private String inputType;
    private ShowByFieldAndVal showByFieldAndVal;

    @JsonIgnore
    public BankLoginConfig set2ReadOnly() {
        this.readOnly = true;
        return this;
    }

    public BankLoginConfig set2MlDesc(MultiLangEnumBridge ml) {
        this.mlDesc = ml;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig set2ShowByFieldAndVal(ShowByFieldAndVal showByFieldAndVal) {
        this.showByFieldAndVal = showByFieldAndVal;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig set2Nullable() {
        this.nullable = true;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig set2Nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig set2InputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    public BankLoginConfig set2Integer() {
        this.inputType = ConfigInputType.INTEGER.getInputType();
        this.minValueNum = 0;
        this.maxValueNum = 0x7FFFFFFE;
        return this;
    }

    public BankLoginConfig set2Date8() {
        this.inputType = ConfigInputType.DATE8.getInputType();
        return this;
    }

    public BankLoginConfig set2IntegerPort() {
        this.inputType = ConfigInputType.INTEGER.getInputType();
        this.minValueNum = 0;
        this.maxValueNum = 65535;
        return this;
    }

    public BankLoginConfig set2MaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public BankLoginConfig set2MinValueNum(Integer minValueNum) {
        this.minValueNum = minValueNum;
        return this;
    }

    public BankLoginConfig set2MaxValueNum(int maxValueNum) {
        this.maxValueNum = maxValueNum;
        return this;
    }

    public List<MultiLangEnumBridge> getMlSourceNames() {
        return this.mlSourceNames;
    }

    public void setMlSourceNames(List<MultiLangEnumBridge> mlSourceNames) {
        if (Objects.nonNull(mlSourceNames)) {
            mlSourceNames.stream().filter(Objects::nonNull).forEach(v -> {
                if (v.getDescription().endsWith("\u3002")) {
                    v.setDescription(v.getDescription().substring(0, v.getDescription().length() - 1));
                }
            });
        }
        this.mlSourceNames = mlSourceNames;
    }

    public MultiLangEnumBridge getMlBankConfigName() {
        return this.mlBankConfigName;
    }

    public void setMlBankConfigName(MultiLangEnumBridge mlBankConfigName) {
        if (Objects.nonNull(mlBankConfigName) && Objects.nonNull(mlBankConfigName.getDescription()) && mlBankConfigName.getDescription().endsWith("\u3002")) {
            mlBankConfigName.setDescription(mlBankConfigName.getDescription().substring(0, mlBankConfigName.getDescription().length() - 1));
        }
        this.mlBankConfigName = mlBankConfigName;
    }

    public MultiLangEnumBridge getMlDesc() {
        return this.mlDesc;
    }

    public BankLoginConfig setMlDesc(MultiLangEnumBridge mlDesc) {
        this.mlDesc = mlDesc;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public BankLoginConfig setDesc(MultiLangEnumBridge desc) {
        this.mlDesc = desc;
        return this;
    }

    @JsonIgnore
    public BankLoginConfig set2password() {
        this.inputType = ConfigInputType.PASSWORD.getInputType();
        return this;
    }

    public String getInputType() {
        if (this.inputType == null) {
            this.inputType = ConfigInputType.TEXT.getInputType();
        }
        return this.inputType;
    }

    public int getMaxLength() {
        if (this.maxLength == null) {
            this.maxLength = 255;
        }
        return this.maxLength;
    }

    public Boolean getHidden() {
        return this.isHidden;
    }

    public BankLoginConfig setHidden(Boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public Integer getMinValueNum() {
        return this.minValueNum;
    }

    public void setMinValueNum(Integer minValueNum) {
        this.minValueNum = minValueNum;
    }

    public Integer getMaxValueNum() {
        return this.maxValueNum;
    }

    public void setMaxValueNum(Integer maxValueNum) {
        this.maxValueNum = maxValueNum;
    }

    public BankLoginConfigKey getKey() {
        return this.key;
    }

    public void setKey(BankLoginConfigKey key) {
        this.key = key;
    }

    public String getBankConfigValue() {
        if (StringUtils.isNotEmpty(this.bankConfigValue)) {
            return this.bankConfigValue;
        }
        return "";
    }

    public void setBankConfigValue(String bankConfigValue) {
        this.bankConfigValue = bankConfigValue;
    }

    public String getBankConfigName() {
        return this.bankConfigName;
    }

    public void setBankConfigName(String bankConfigName) {
        this.bankConfigName = bankConfigName;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public List<String> getSourceValues() {
        return this.sourceValues;
    }

    public void setSourceValues(List<String> sourceValues) {
        this.sourceValues = sourceValues;
    }

    public List<String> getSourceNames() {
        return this.sourceNames;
    }

    public void setSourceNames(List<String> sourceNames) {
        this.sourceNames = sourceNames;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ShowByFieldAndVal getShowByFieldAndVal() {
        return this.showByFieldAndVal;
    }

    public void setShowByFieldAndVal(ShowByFieldAndVal showByFieldAndVal) {
        this.showByFieldAndVal = showByFieldAndVal;
    }

    public List<MultiLangEnumBridge> getMlDescs() {
        return this.mlDescs;
    }

    public void setMlDescs(List<MultiLangEnumBridge> mlDescs) {
        this.mlDescs = mlDescs;
    }
}

