/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.model.monitor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;

public class LoginMonitorStatisticInfo
implements Serializable {
    private Integer totalBlockTime;
    private Integer totalProcessTime;
    private Integer blockCount;
    private Integer totalCount;
    private String tag;
    private Integer qty;
    private TimeUnit timeUnit;
    private Integer LoginLockNum;
    private Double blockRate;
    private Double processRate;
    private Boolean needCache;
    private String timeSlot;

    public LoginMonitorStatisticInfo() {
        this.setTotalProcessTime(0);
        this.setTotalBlockTime(0);
        this.setTotalCount(0);
        this.setBlockCount(0);
        this.setQty(0);
        this.setTimeUnit(TimeUnit.HOURS);
    }

    public Integer getTotalBlockTime() {
        return this.totalBlockTime;
    }

    public void setTotalBlockTime(Integer totalBlockTime) {
        this.totalBlockTime = totalBlockTime;
    }

    public Integer getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public void setTotalProcessTime(Integer totalProcessTime) {
        this.totalProcessTime = totalProcessTime;
    }

    public Integer getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(Integer blockCount) {
        this.blockCount = blockCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public String getTag() {
        String unit = "";
        if (this.timeUnit.compareTo(TimeUnit.MINUTES) == 0) {
            unit = ResManager.loadKDString((String)"\u5206\u949f", (String)"LoginMonitorStatisticInfo_0", (String)"ebg-egf-common", (Object[])new Object[0]);
        } else if (this.timeUnit.compareTo(TimeUnit.HOURS) == 0) {
            unit = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"LoginMonitorStatisticInfo_1", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u6700\u8fd1", (String)"LoginMonitorStatisticInfo_2", (String)"ebg-egf-common", (Object[])new Object[0])).append(this.tag).append(unit);
        return sb.toString();
    }

    public void setTag(String tag) {
        this.tag = tag;
        this.needCache = !tag.equalsIgnoreCase("1");
        if (this.qty == 0) {
            try {
                this.qty = Integer.parseInt(tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getQty() {
        return this.qty;
    }

    public void setQty(int qty) {
        this.qty = qty;
    }

    public Integer getLoginLockNum() {
        return this.LoginLockNum;
    }

    public void setLoginLockNum(Integer loginLockNum) {
        this.LoginLockNum = loginLockNum;
    }

    public Double getBlockRate() {
        if (this.totalCount == 0) {
            return 0.0;
        }
        BigDecimal bd = BigDecimal.valueOf((float)this.blockCount.intValue() / (float)this.totalCount.intValue());
        double temp = bd.setScale(2, 4).doubleValue();
        this.blockRate = Double.valueOf(String.format("%.2f", temp * 100.0));
        return this.blockRate;
    }

    public Double getProcessRate() {
        int unit = 36000;
        if (this.timeUnit.compareTo(TimeUnit.MINUTES) == 0) {
            unit = 600;
        } else if (this.timeUnit.compareTo(TimeUnit.HOURS) == 0) {
            unit = 36000;
        }
        BigDecimal bd = BigDecimal.valueOf((float)this.totalProcessTime.intValue() / (float)unit);
        double temp = bd.setScale(2, 4).doubleValue();
        this.processRate = Double.valueOf(String.format("%.2f", temp));
        return this.processRate;
    }

    public void setProcessRate(Double processRate) {
        this.processRate = processRate;
    }

    public Boolean isNeedCache() {
        return this.needCache;
    }

    public String getTimeSlot() {
        return this.timeSlot;
    }

    public void setTimeSlot(String timeSlot) {
        this.timeSlot = timeSlot;
    }
}

