/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.codeless;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.model.codeless.JudgingConditionBody;
import kd.ebg.egf.common.model.codeless.RouteBody;
import kd.ebg.egf.common.repository.codeless.JudgingConditionRepository;

public class CodeLessRouteRepository {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodeLessRouteRepository.class);
    private static CodeLessRouteRepository instance = new CodeLessRouteRepository();
    private static final String ENTITY_NAME = "note_route_manage";

    public static CodeLessRouteRepository getInstance() {
        return instance;
    }

    public CodeLessRoute findByBankVersionIDAndBizType(String bankVersionID, String bizType, String app) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(bankVersionID + "_" + app)), new QFilter("sub_biz_type.number", "=", (Object)bizType), new QFilter("biz_type", "=", (Object)app)});
        return this.transCodeLessRoute(bankVersionID, dynamicObject, app);
    }

    private CodeLessRoute transCodeLessRoute(String bankVersionID, DynamicObject dynamicObject, String app) {
        if (dynamicObject == null) {
            return null;
        }
        CodeLessRoute route = new CodeLessRoute();
        route.setBankVersionID(bankVersionID);
        route.setAppCode(app);
        route.setNumber(dynamicObject.getString("number"));
        route.setName(dynamicObject.getString("name"));
        route.setEnable(dynamicObject.getString("enable"));
        route.setStatus(dynamicObject.getString("status"));
        route.setBizType(dynamicObject.getString("biz_type"));
        DynamicObject sub_biz_type = dynamicObject.getDynamicObject("sub_biz_type");
        route.setBizTypeNumber(sub_biz_type.getString("number"));
        route.setBatchSize(dynamicObject.getInt("biz_count"));
        DynamicObjectCollection headers = dynamicObject.getDynamicObjectCollection("routes_entity");
        ArrayList<RouteBody> routeBodies = new ArrayList<RouteBody>(1);
        if (!headers.isEmpty()) {
            for (DynamicObject header : headers) {
                RouteBody routeBody = new RouteBody();
                routeBody.setCombofield(header.getString("combofield"));
                routeBody.setInterfaceCount(header.getInt("interface_count"));
                routeBody.setSeq(header.getInt("seq"));
                DynamicObject interface_name = header.getDynamicObject("interface_name");
                routeBody.setInterfaceName(interface_name.getString("trans_code"));
                DynamicObject judgingConditions = header.getDynamicObject("interface_condition");
                if (judgingConditions != null) {
                    JudgingConditionRepository repository = JudgingConditionRepository.getInstance();
                    List<JudgingConditionBody> bodies = repository.findByNumber(judgingConditions.getString("number"));
                    routeBody.setJudgingConditionBodies(bodies);
                }
                routeBodies.add(routeBody);
            }
        }
        headers = dynamicObject.getDynamicObjectCollection("note_routes_query");
        ArrayList<RouteBody> routeBodiesQuery = new ArrayList<RouteBody>(1);
        if (!headers.isEmpty()) {
            for (DynamicObject header : headers) {
                RouteBody routeBody = new RouteBody();
                routeBody.setCombofield(header.getString("combofield1"));
                routeBody.setSeq(header.getInt("seq"));
                DynamicObject interface_name = header.getDynamicObject("interface_name1");
                routeBody.setInterfaceName(interface_name.getString("trans_code"));
                DynamicObject judgingConditions = header.getDynamicObject("interface_condition1");
                if (judgingConditions != null) {
                    JudgingConditionRepository repository = JudgingConditionRepository.getInstance();
                    List<JudgingConditionBody> bodies = repository.findByNumber(judgingConditions.getString("number"));
                    routeBody.setJudgingConditionBodies(bodies);
                }
                routeBodiesQuery.add(routeBody);
            }
        }
        route.setRouteBodiesQuery(routeBodiesQuery);
        route.setRouteBodies(routeBodies);
        return route;
    }

    public int countDistinctBankVersionIDByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"count(distinct group) as count", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            return dynamicObject.getInt("count");
        }
        return 0;
    }

    public String findBankVersionNumberByID(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"group.longnumber", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{id})});
        return dynamicObject != null ? dynamicObject.getString("group.longnumber").split("\\.")[0] : "";
    }

    public List<Long> findJudgingConditionsIdsByIds(List<Long> ids) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            result = this.transJudgingConditionsIds(dynamicObjectMap);
        }
        return result;
    }

    private List<Long> transJudgingConditionsIds(Map<Object, DynamicObject> dynamicObjectMap) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (!dynamicObjectMap.isEmpty()) {
            HashSet<Long> sets = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("bodyentryentity");
                this.getJudgingConditionIds(sets, bodys, "judging_conditions");
                DynamicObjectCollection bodys2 = dynamicObject.getDynamicObjectCollection("bodyfilenameentity");
                this.getJudgingConditionIds(sets, bodys2, "judging_conditions3");
                DynamicObjectCollection bodys3 = dynamicObject.getDynamicObjectCollection("bodyfilecontentity");
                this.getJudgingConditionIds(sets, bodys3, "judging_conditions2");
            }
            result.addAll(sets);
        }
        return result;
    }

    private void getJudgingConditionIds(Set<Long> ids, DynamicObjectCollection bodys, String judgingConditionsKey) {
        if (!bodys.isEmpty()) {
            for (DynamicObject body : bodys) {
                DynamicObject judgingConditions = body.getDynamicObject(judgingConditionsKey);
                if (judgingConditions == null) continue;
                ids.add(judgingConditions.getLong("id"));
            }
        }
    }

    public String findNumberByID(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"number", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{id})});
        return dynamicObject != null ? dynamicObject.getString("number") : "";
    }
}

