/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.currency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.model.currency.IsoCurrency;

public class IsoCurrencyRepository {
    private String ISO_ENTITY = "aqap_iso_currency";
    private static IsoCurrencyRepository instance = new IsoCurrencyRepository();

    public static IsoCurrencyRepository getInstance() {
        return instance;
    }

    public List<IsoCurrency> findAll() {
        ArrayList<IsoCurrency> isoCurrencyList = new ArrayList<IsoCurrency>(1);
        String selectProperties = "number,name";
        Map map = BusinessDataServiceHelper.loadFromCache((String)this.ISO_ENTITY, (String)selectProperties, null);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                IsoCurrency isoCurrency = new IsoCurrency();
                isoCurrency.setIsoCode(dynamicObject.getString("number"));
                isoCurrency.setCurrencyName(dynamicObject.getString("name"));
                isoCurrencyList.add(isoCurrency);
            }
        }
        return isoCurrencyList;
    }

    public List<IsoCurrency> findAllWithoutCache() {
        ArrayList<IsoCurrency> isoCurrencyList = new ArrayList<IsoCurrency>(1);
        String selectProperties = "number,name";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ISO_ENTITY, (String)selectProperties, null);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject entity : dynamicObjects) {
                IsoCurrency isoCurrency = new IsoCurrency();
                isoCurrency.setIsoCode(entity.getString("number"));
                isoCurrency.setCurrencyName(entity.getString("name"));
                isoCurrencyList.add(isoCurrency);
            }
        }
        return isoCurrencyList;
    }

    public IsoCurrency findOne(String isoCode) {
        IsoCurrency isoCurrency = this.findOneDefaultNull(isoCode);
        if (isoCurrency == null) {
            isoCurrency = new IsoCurrency();
            isoCurrency.setIsoCode("CNY");
            isoCurrency.setCurrencyName(ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"IsoCurrencyRepository_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        return isoCurrency;
    }

    public IsoCurrency findOneDefaultNull(String isoCode) {
        IsoCurrency isoCurrency = new IsoCurrency();
        String selectProperties = "number,name";
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{isoCode});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.ISO_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            isoCurrency.setIsoCode(isoCode);
            isoCurrency.setCurrencyName(dynamicObject.getString("name"));
        } else {
            isoCurrency = null;
        }
        return isoCurrency;
    }

    public IsoCurrency findById(Long id) {
        IsoCurrency isoCurrency = new IsoCurrency();
        String selectProperties = "number,name";
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.ISO_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            isoCurrency.setIsoCode(dynamicObject.getString("number"));
            isoCurrency.setCurrencyName(dynamicObject.getString("name"));
        } else {
            isoCurrency.setIsoCode("CNY");
            isoCurrency.setCurrencyName(ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"IsoCurrencyRepository_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        return isoCurrency;
    }
}

