/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.currency;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MappingCurrencyRepository {
    private String MAPPING_CURRENCY_ENTITY = "aqap_mapping_currency";
    private String selectProperties = "number,name,iso.number,bd_currency.number";
    private static MappingCurrencyRepository instance = new MappingCurrencyRepository();

    public static MappingCurrencyRepository getInstance() {
        return instance;
    }

    public String getISOMappingCurrency(String currency) {
        if (StringUtils.isNotEmpty(currency)) {
            QFilter filter = QFilter.of((String)"bd_currency.number=?", (Object[])new Object[]{currency});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.MAPPING_CURRENCY_ENTITY, (String)this.selectProperties, (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                return dynamicObject.getString("iso.number");
            }
            return currency;
        }
        return "";
    }

    public String getBizMappingCurrency(String isoCurrency) {
        if (StringUtils.isNotEmpty(isoCurrency)) {
            QFilter filter = QFilter.of((String)"iso.number=?", (Object[])new Object[]{isoCurrency});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.MAPPING_CURRENCY_ENTITY, (String)this.selectProperties, (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                return dynamicObject.getString("bd_currency.number");
            }
            return isoCurrency;
        }
        return "";
    }

    public String getISOMappingCurrency(String bizCurrency, Map<String, String> currencyMap) {
        if (currencyMap == null) {
            currencyMap = new HashMap<String, String>(16);
        }
        if (!currencyMap.containsKey(bizCurrency)) {
            String isoCurrency = this.getISOMappingCurrency(bizCurrency);
            currencyMap.put(bizCurrency, isoCurrency);
            return isoCurrency;
        }
        return currencyMap.get(bizCurrency);
    }

    public String getBizMappingCurrency(String isoCurrency, Map<String, String> currencyMap) {
        if (currencyMap == null) {
            currencyMap = new HashMap<String, String>(16);
        }
        if (!currencyMap.containsKey(isoCurrency)) {
            String bizCurrency = this.getBizMappingCurrency(isoCurrency);
            currencyMap.put(isoCurrency, bizCurrency);
            return bizCurrency;
        }
        return currencyMap.get(isoCurrency);
    }
}

