/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.license;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class LicenseFileRepository {
    private String LICENSE_FILE_ENTITY = "aqap_license_file";
    private String SELECT_ALL_PROPERTIES = "id,custom_id,upload_time,expire_time,license_file_tag,license_count";
    private static LicenseFileRepository instance = new LicenseFileRepository();

    public static LicenseFileRepository getInstance() {
        return instance;
    }

    public void save(LicenseFile licenseFile) {
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.LICENSE_FILE_ENTITY);
        dynamicObject.set("upload_time", (Object)now);
        dynamicObject.set("custom_id", (Object)licenseFile.getCustomId());
        dynamicObject.set("expire_time", (Object)Date.from(licenseFile.getExpireTime().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("license_count", (Object)licenseFile.getLicenseCount());
        String licenseContent = Base64.getEncoder().encodeToString(licenseFile.getFileBytes());
        dynamicObject.set("license_file_tag", (Object)licenseContent);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public LicenseFile findByMd5(String md5) {
        return new LicenseFile();
    }

    public LicenseFile findBySha1(String sha1) {
        return new LicenseFile();
    }

    public LicenseFile findByCustomId(String customId) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.LICENSE_FILE_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return this.transferLicenseInfo(dynamicObject);
    }

    private LicenseFile transferLicenseInfo(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        LicenseFile licenseFile = new LicenseFile();
        licenseFile.setId(dynamicObject.getLong("id"));
        licenseFile.setLicenseCount(dynamicObject.getInt("license_count"));
        licenseFile.setCustomId(dynamicObject.getString("custom_id"));
        licenseFile.setUploadTime(LocalDateUtil.date2LocalDateTime(dynamicObject.getDate("upload_time")));
        licenseFile.setExpireTime(LocalDateUtil.date2LocalDateTime(dynamicObject.getDate("expire_time")));
        licenseFile.setFileBytes(Base64.getDecoder().decode(dynamicObject.getString("license_file_tag")));
        return licenseFile;
    }

    public List<LicenseFile> findAll() {
        return new ArrayList<LicenseFile>(1);
    }
}

