/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.tenant;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;

public class TenantAuthRepository {
    private String ENTITY = "aqap_bd_cert";
    private String SELECT_PROPERTIES = "file_name, organization, bank_config_value_tag, expire_time, custom_id, alert_day, is_alert";
    private static TenantAuthRepository instance = new TenantAuthRepository();

    public static TenantAuthRepository getInstance() {
        return instance;
    }

    public List<TenantAuth> findAll() {
        ArrayList<TenantAuth> authList = new ArrayList<TenantAuth>(1);
        DynamicObject[] dynamicObjects = QueryCacheUtil.getDynamicObjects(this.ENTITY, this.SELECT_PROPERTIES, new QFilter[]{new QFilter("type", "=", (Object)CertType.CA_CER.getType())});
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                TenantAuth tenantAuth = new TenantAuth();
                tenantAuth.setCertificateName(dynamicObjects[i].getString("file_name"));
                tenantAuth.setCommonName("");
                tenantAuth.setCustomID(dynamicObjects[i].getString("custom_id"));
                tenantAuth.setOrganization(dynamicObjects[i].getString("organization"));
                tenantAuth.setPublicKey(dynamicObjects[i].getString("bank_config_value_tag"));
                tenantAuth.setExpireTime(DTFactoryUtil.parseDateTime(dynamicObjects[i].getDate("expire_time")));
                tenantAuth.setStatus(1);
                authList.add(tenantAuth);
            }
        }
        return authList;
    }

    public List<TenantAuth> findByCustomID(String customID) {
        ArrayList<TenantAuth> authList = new ArrayList<TenantAuth>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and type=?", (Object[])new Object[]{customID, CertType.CA_CER.getType()});
        DynamicObject[] dynamicObjects = QueryCacheUtil.getDynamicObjects(this.ENTITY, this.SELECT_PROPERTIES, filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                TenantAuth tenantAuth = new TenantAuth();
                tenantAuth.setCertificateName(dynamicObjects[i].getString("file_name"));
                tenantAuth.setCommonName("");
                tenantAuth.setCustomID(customID);
                tenantAuth.setOrganization(dynamicObjects[i].getString("organization"));
                tenantAuth.setPublicKey(dynamicObjects[i].getString("bank_config_value_tag"));
                tenantAuth.setExpireTime(DTFactoryUtil.parseDateTime(dynamicObjects[i].getDate("expire_time")));
                tenantAuth.setStatus(1);
                authList.add(tenantAuth);
            }
        }
        return authList;
    }

    public List<TenantAuth> findByCustomIDAndExpireTimeGreaterThanAndStatus(String customID, LocalDateTime date, Integer status) {
        ArrayList<TenantAuth> authList = new ArrayList<TenantAuth>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and expire_time>? and type=?", (Object[])new Object[]{customID, date, CertType.CA_CER.getType()});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                TenantAuth tenantAuth = new TenantAuth();
                tenantAuth.setCertificateName(dynamicObjects[i].getString("file_name"));
                tenantAuth.setCommonName("");
                tenantAuth.setCustomID(customID);
                tenantAuth.setOrganization(dynamicObjects[i].getString("organization"));
                tenantAuth.setPublicKey(dynamicObjects[i].getString("bank_config_value_tag"));
                tenantAuth.setExpireTime(DTFactoryUtil.parseDateTime(dynamicObjects[i].getString("expire_time")));
                tenantAuth.setStatus(1);
                authList.add(tenantAuth);
            }
        }
        return authList;
    }
}

