/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import kd.ebg.egf.common.framework.biz.IBankResponseResult;

public abstract class AbstractBankResponseResult
implements IBankResponseResult {
    private String responseCode;
    private String id = "";
    private String bankMessage;
    protected boolean isSuccess = false;
    protected boolean isFailed = false;
    protected String[] successCodes = new String[]{"1"};
    protected String[] failedCodes = new String[]{"0"};

    public AbstractBankResponseResult(String bankResponseCode) {
        this.responseCode = bankResponseCode;
        this.excuteResult();
    }

    private void initFlags() {
        this.isSuccess = false;
        this.isFailed = false;
    }

    public AbstractBankResponseResult(String bankResponseCode, String[] bankSuccessCodes, String[] bankFailedCodes) {
        this.responseCode = bankResponseCode;
        if (null != bankSuccessCodes) {
            this.successCodes = bankSuccessCodes;
        }
        if (null != bankFailedCodes) {
            this.failedCodes = bankFailedCodes;
        }
        this.excuteResult();
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public boolean isUnkown() {
        return !this.isSuccess && !this.isFailed;
    }

    public String[] getSuccessCodes() {
        return this.successCodes;
    }

    public void setSuccessCodes(String[] successCodes) {
        this.successCodes = successCodes;
        this.initFlags();
        this.excuteResult();
    }

    public String[] getFailedCodes() {
        return this.failedCodes;
    }

    public void setFailedCodes(String[] failedCodes) {
        this.failedCodes = failedCodes;
        this.initFlags();
        this.excuteResult();
    }

    @Override
    public boolean isFailed() {
        return this.isFailed;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBankMessage() {
        return this.bankMessage;
    }

    public void setBankMessage(String bankMessage) {
        this.bankMessage = bankMessage;
    }
}

