/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LocalDateUtil {
    public static String formatDate(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return formatter.format(date);
    }

    public static LocalDate parserMonth(String date) {
        DateTimeFormatter fmt = new DateTimeFormatterBuilder().appendPattern("yyyyMM").parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter();
        return LocalDate.parse(date, fmt);
    }

    public static String formatDate(LocalDate date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.format(date);
    }

    public static String formatDate(LocalDateTime date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return formatter.format(date);
    }

    public static String formatDate(LocalDateTime date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.format(date);
    }

    public static LocalDate parserDate(String dateStr) {
        if (StringUtils.isNotEmpty(dateStr) && dateStr.contains("-")) {
            return LocalDateUtil.parserDate(dateStr, "yyyy-MM-dd");
        }
        return LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static LocalDate parserDate(String dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.parse(dateStr, formatter);
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDate) {
        if (null == localDate) {
            return null;
        }
        Date date = Date.from(localDate.atZone(ZoneOffset.ofHours(8)).toInstant());
        return date;
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    public static LocalDateTime getLastTimeByLocalDate(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MAX);
    }

    public static LocalDateTime getFirstTimeByLocalDate(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static LocalDateTime getLastTimeByDate(Date date) {
        LocalDate localDate = LocalDateUtil.date2LocalDate(date);
        return LocalDateTime.of(localDate, LocalTime.MAX);
    }

    public static LocalDateTime getFirstTimeByDate(Date date) {
        LocalDate localDate = LocalDateUtil.date2LocalDate(date);
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static LocalDate getDayAfter(LocalDate localDate, int day) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, day);
        date = c.getTime();
        Instant instant = date.toInstant();
        localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static List<String> getMonthsBetweenDate(LocalDate startDate, LocalDate endDate) {
        ArrayList<String> months = new ArrayList<String>(16);
        String startMonth = LocalDateUtil.formatDate(startDate, "yyyyMM");
        String endMonth = LocalDateUtil.formatDate(endDate, "yyyyMM");
        startDate = LocalDateUtil.parserDate(startMonth + "01");
        endDate = LocalDateUtil.parserDate(endMonth + "01");
        months.add(startMonth);
        while (startDate.isBefore(endDate)) {
            startDate = startDate.plusMonths(1L);
            String month = LocalDateUtil.formatDate(startDate, "yyyyMM");
            months.add(month);
        }
        return months;
    }

    public static LocalDateTime parseDateTime(String localDateTime) {
        if (localDateTime == null) {
            throw new EBServiceException("input param 'localDateTime' is null");
        }
        if (localDateTime.length() > 14) {
            localDateTime = localDateTime.substring(0, 14);
        } else if (localDateTime.length() < 14) {
            StringBuilder builder = new StringBuilder(localDateTime);
            while (builder.length() < 14) {
                builder.append('0');
            }
            localDateTime = builder.toString();
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return LocalDateTime.parse(localDateTime, dateTimeFormatter);
    }

    public static LocalDateTime parseDateTime(String localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(localDateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String formatLocalTime(LocalTime localTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HHmmss");
        return localTime.format(dateTimeFormatter);
    }
}

