/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.log;

import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.operate.FormOperate;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OperationLogUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OperationLogUtil.class);
    public static String SEARCH_KEY = "ebg";

    public static void recordInvoke(String message, String appId, String objectId, String opName) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpDescription(message);
        appLogInfo.setOpName(opName);
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(objectId);
    }

    public static void recordInvoke(String message, String appId, FormOperate formOperate) {
        String objectId = formOperate.getEntityId();
        String opName = formOperate.getOperateName().getLocaleValue();
        if (StringUtils.isEmpty(opName)) {
            opName = formOperate.getOperateKey();
        }
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpDescription(message);
        appLogInfo.setOpName(opName);
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(objectId);
    }

    public static void recordInvoke(String appId, String objectId, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, String ... args) {
        OpLogAppInfo appLogInfo = OperationLogUtil.getOpLogAppInfo(appId, objectId, opKey, opNameBridge, descBridge, args);
        OperationLogUtil.save(appLogInfo);
    }

    public static OpLogAppInfo getOpLogAppInfo(String appId, String objectId, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, String ... args) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(objectId);
        appLogInfo.setOpDesc(descBridge, args);
        appLogInfo.setOpName(opKey, opNameBridge);
        appLogInfo.setKeyWord(SEARCH_KEY);
        return appLogInfo;
    }

    public static void recordInvoke(OpLogAppInfo appLogInfo) {
        OperationLogUtil.save(appLogInfo);
    }

    public static void recordInvoke(String appId, FormOperate formOperate, MultiLangEnumBridge descBridge) {
        Object param = null;
        OperationLogUtil.recordInvoke(appId, formOperate, descBridge, param);
    }

    public static void recordInvoke(String appId, FormOperate formOperate, MultiLangEnumBridge descBridge, String ... args) {
        OpLogAppInfo appLogInfo = OperationLogUtil.getOpLogAppInfo(appId, formOperate, descBridge, args);
        OperationLogUtil.save(appLogInfo);
    }

    public static OpLogAppInfo getOpLogAppInfo(String appId, FormOperate formOperate, MultiLangEnumBridge descBridge, String ... args) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(formOperate.getEntityId());
        appLogInfo.setOpDesc(descBridge, args);
        appLogInfo.setOpName(formOperate.getOperateKey(), formOperate.getOperateName().getLocaleValue_zh_CN());
        appLogInfo.setKeyWord(SEARCH_KEY);
        return appLogInfo;
    }

    public static MultiLangEnumBridge getMultiLangEnumBridge(String message, String resourceID, String projectID) {
        return new MultiLangEnumBridge(message, resourceID, projectID);
    }

    private static void save(OpLogAppInfo appLogInfo) {
        try {
            ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
            service.addLog((AppLogInfo)appLogInfo);
        }
        catch (Throwable t) {
            logger.error("save OpLogAppInfo error", t);
        }
    }
}

