/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class StringCompressor {
    public static String compressString(String input) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
            gzipOutputStream.write(input.getBytes("UTF-8"));
        }
        return Base64.encodeBase64String((byte[])outputStream.toByteArray());
    }

    public static String decompressString(String compressedBase64) throws IOException {
        byte[] compressedBytes = Base64.decodeBase64((String)compressedBase64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedBytes);
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int len;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = gzipInputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            String string = outputStream.toString("UTF-8");
            return string;
        }
    }
}

