/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.unittest.ZipTools;
import kd.bos.form.IFormView;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.repository.codeless.CodeLessRepository;
import kd.ebg.egf.common.repository.codeless.CodeLessRouteRepository;
import kd.ebg.egf.common.repository.codeless.JudgingConditionsRepository;
import kd.ebg.egf.common.repository.codeless.PageSchemeRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.formplugin.plugin.util.AbstractDataSetOperater;

public class ExportKsqlUtils {
    private static final String recordFileName = "readme.txt";
    private static final String recordNoteXmlPrefix = "<SqlScript Type=\"KSQL\" Separator=\";\" dbkey=\"ebg\">preinsdata/codeless/";
    private static final String recordNoteXmlSuffix = "</SqlScript>";
    private static final String recordFileListPrefix = "/1.5/main/note/preinsdata/codeless/";
    private static final String recordStart = ExportKsqlUtils.getRecordStart();
    private static final String noteXmlRecordStart = ExportKsqlUtils.getNoteXmlRecordStart();
    private static final String fileListRecordStart = ExportKsqlUtils.getFileListRecordStart();

    private static String getRecordStart() {
        return ResManager.loadKDString((String)"-- \u8bf7\u5c06\u5bf9\u5e94\u811a\u672c\u6587\u4ef6\u62f7\u8d1d\u5230\u5bf9\u5e94\u94f6\u884c\u7248\u672c\u6587\u4ef6\u5939\u4e0b\uff0c\u5e76\u4fee\u6539note.xml\u53cafilelist.txt\u6587\u4ef6", (String)"ExportKsqlUtils_0", (String)"ebg-note-formplugin", (Object[])new Object[0]);
    }

    private static String getNoteXmlRecordStart() {
        return ResManager.loadKDString((String)"-- \u8bf7\u5c06\u4e0b\u65b9\u5185\u5bb9\u62f7\u8d1d\u5230note.xml\u6587\u4ef6\u4e2d", (String)"ExportKsqlUtils_1", (String)"ebg-note-formplugin", (Object[])new Object[0]);
    }

    private static String getFileListRecordStart() {
        return ResManager.loadKDString((String)"-- \u8bf7\u5c06\u4e0b\u65b9\u5185\u5bb9\u62f7\u8d1d\u5230filelist.txt\u6587\u4ef6\u4e2d", (String)"ExportKsqlUtils_2", (String)"ebg-note-formplugin", (Object[])new Object[0]);
    }

    private static String getSqlNamePrefix() {
        return "kd_1.5." + DateUtil.formatDateTime((Date)new Date()) + "_ebg_note_";
    }

    private static String getZipName() {
        return "ebg_note_code_less_" + DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".zip";
    }

    private static String getCodeLessSqlName(Long id) {
        CodeLessRepository codeLessRepository = CodeLessRepository.getInstance();
        return ExportKsqlUtils.getSqlNamePrefix() + "code_less_" + codeLessRepository.findNumberByID(id).replace("/", "").replace("\\", "") + ".sql";
    }

    private static String getJudgingConditionsSqlName() {
        return ExportKsqlUtils.getSqlNamePrefix() + "judging_conditions.sql";
    }

    private static String getPageSchemeSqlName() {
        return ExportKsqlUtils.getSqlNamePrefix() + "pageSchemes.sql";
    }

    private static String getPageParmSqlName() {
        return ExportKsqlUtils.getSqlNamePrefix() + "pageParams.sql";
    }

    private static String getJudgingConditionSqlName() {
        return ExportKsqlUtils.getSqlNamePrefix() + "judging_condition.sql";
    }

    public static List<Map<String, Object>> getKSql(List<Long> listIds, String key) {
        AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(key);
        List<Map<String, Object>> lstMap = dbOperator.getExpDataSetSqlWithIds(listIds);
        return lstMap;
    }

    public static List<Map<String, Object>> getCodeLessKSql(List<Long> listIds) {
        return ExportKsqlUtils.getKSql(listIds, "ebg_code_less");
    }

    public static List<Map<String, Object>> getRouteKSql(List<Long> listIds) {
        return ExportKsqlUtils.getKSql(listIds, "note_route_manage");
    }

    public static List<Map<String, Object>> getPageKSql(List<Long> listIds) {
        return ExportKsqlUtils.getKSql(listIds, "lastpage_entity");
    }

    public static void exportKsql(List<Long> listIds, IFormView formView, String bankVersionID) {
        String zipName = ExportKsqlUtils.getZipName();
        File zipFile = new File(zipName);
        try {
            ZipTools.ZipParam recordFileZipParam;
            String pageSchemeSqlName;
            List PageSchemeIds;
            List<Map<String, Object>> PageSchemKsqls;
            ZipTools.ZipParam pageSchemeZipParam;
            String judgingConditionsSqlName;
            ArrayList<ZipTools.ZipParam> lstParam = new ArrayList<ZipTools.ZipParam>(16);
            List<Map<String, Object>> kSqls = ExportKsqlUtils.getCodeLessKSql(listIds);
            if (CollectionUtils.isEmpty(kSqls)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6ksql\u4e3a\u7a7a\u3002", (String)"ExportKsqlUtils_3", (String)"ebg-note-formplugin", (Object[])new Object[0]));
            }
            StringBuilder recordNoteXmlContent = new StringBuilder();
            StringBuilder recordFileListContent = new StringBuilder();
            recordNoteXmlContent.append(recordStart).append("\r\n").append(noteXmlRecordStart).append("\r\n");
            recordFileListContent.append(fileListRecordStart).append("\r\n");
            for (Map<String, Object> map : kSqls) {
                String fileName = bankVersionID + "/" + ExportKsqlUtils.getCodeLessSqlName((Long)map.get("id"));
                String xmlSql = (String)map.get("sql");
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(fileName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(fileName).append("\r\n");
                ByteArrayInputStream sqlStream = new ByteArrayInputStream(xmlSql.getBytes(StandardCharsets.UTF_8));
                ZipTools.ZipParam param = new ZipTools.ZipParam();
                param.isfile = true;
                param.name = fileName;
                param.stream = sqlStream;
                lstParam.add(param);
            }
            CodeLessRepository codeLessRepository = CodeLessRepository.getInstance();
            List JudgingConditionsIds = codeLessRepository.findJudgingConditionsIdsByIds(listIds);
            List<Map<String, Object>> JudgingConditionsKSqls = ExportKsqlUtils.getKSql(JudgingConditionsIds, "ebg_judging_conditions");
            ZipTools.ZipParam judgingConditionsZipParam = ExportKsqlUtils.getJudgingConditionsZipParam(JudgingConditionsKSqls, judgingConditionsSqlName = bankVersionID + "/" + ExportKsqlUtils.getJudgingConditionsSqlName());
            if (judgingConditionsZipParam != null) {
                lstParam.add(judgingConditionsZipParam);
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(judgingConditionsSqlName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(judgingConditionsSqlName).append("\r\n");
            }
            if ((pageSchemeZipParam = ExportKsqlUtils.getJudgingConditionsZipParam(PageSchemKsqls = ExportKsqlUtils.getKSql(PageSchemeIds = codeLessRepository.findPageSchemeIdsByIds(listIds), "ebg_page_scheme"), pageSchemeSqlName = bankVersionID + "/" + ExportKsqlUtils.getPageSchemeSqlName())) != null) {
                lstParam.add(pageSchemeZipParam);
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(pageSchemeSqlName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(pageSchemeSqlName).append("\r\n");
            }
            PageSchemeRepository pageSchemeRepository = PageSchemeRepository.getInstance();
            ArrayList<Long> PageParamIds = new ArrayList<Long>(16);
            PageParamIds.addAll(pageSchemeRepository.findPageSchemeByIds(PageSchemeIds));
            List<Map<String, Object>> pageParamsKsqls = ExportKsqlUtils.getKSql(PageParamIds, "ebg_page_param");
            String PageParamsSqlName = bankVersionID + "/" + ExportKsqlUtils.getPageParmSqlName();
            ZipTools.ZipParam PageParamsZipParam = ExportKsqlUtils.getJudgingConditionsZipParam(pageParamsKsqls, PageParamsSqlName);
            if (PageParamsZipParam != null) {
                lstParam.add(PageParamsZipParam);
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(PageParamsSqlName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(PageParamsSqlName).append("\r\n");
            }
            JudgingConditionsRepository judgingConditionsRepository = JudgingConditionsRepository.getInstance();
            ArrayList<Long> JudgingConditionIds = new ArrayList<Long>(16);
            JudgingConditionIds.addAll(judgingConditionsRepository.findJudgingConditionIdsByIds(JudgingConditionsIds));
            JudgingConditionIds.addAll(codeLessRepository.findJudgingConditionIdsByIds(listIds));
            List<Map<String, Object>> JudgingConditionKSqls = ExportKsqlUtils.getKSql(JudgingConditionIds, "ebg_judging_condition");
            String judgingConditionSqlName = bankVersionID + "/" + ExportKsqlUtils.getJudgingConditionSqlName();
            ZipTools.ZipParam judgingConditionZipParam = ExportKsqlUtils.getJudgingConditionsZipParam(JudgingConditionKSqls, judgingConditionSqlName);
            if (judgingConditionZipParam != null) {
                lstParam.add(judgingConditionZipParam);
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(judgingConditionSqlName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(judgingConditionSqlName).append("\r\n");
            }
            if ((recordFileZipParam = ExportKsqlUtils.getRecordFileZipParam(recordNoteXmlContent.append((CharSequence)recordFileListContent).toString())) != null) {
                recordFileZipParam.direct = bankVersionID;
                lstParam.add(recordFileZipParam);
            }
            ZipTools.zipStreams(lstParam, (File)zipFile);
        }
        catch (Exception var38) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ExportKsqlUtils_4", (String)"ebg-note-formplugin", (Object[])new Object[0]), var38.getMessage()));
            return;
        }
        ExportKsqlUtils.downloadZipFile(formView, zipFile, zipName);
    }

    private static ZipTools.ZipParam getRecordFileZipParam(String recordContent) {
        if (StringUtils.isEmpty((String)recordContent)) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(recordContent.getBytes(StandardCharsets.UTF_8));
        ZipTools.ZipParam param = new ZipTools.ZipParam();
        param.isfile = true;
        param.name = recordFileName;
        param.stream = stream;
        return param;
    }

    private static ZipTools.ZipParam getJudgingConditionsZipParam(List<Map<String, Object>> JudgingConditionsKSqls, String fileName) {
        if (CollectionUtils.isEmpty(JudgingConditionsKSqls)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map<String, Object> map : JudgingConditionsKSqls) {
            stringBuilder.append((String)map.get("sql"));
        }
        ByteArrayInputStream sqlStream = new ByteArrayInputStream(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        ZipTools.ZipParam param = new ZipTools.ZipParam();
        param.isfile = true;
        param.name = fileName;
        param.stream = sqlStream;
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadZipFile(IFormView formView, File zipFile, String zipName) {
        try (FileInputStream zipFileInputStream = new FileInputStream(zipFile);){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, (InputStream)zipFileInputStream, 5);
            zipFileInputStream.close();
            formView.download(urls);
        }
        catch (Exception var36) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ExportKsqlUtils_4", (String)"ebg-note-formplugin", (Object[])new Object[0]), var36.getMessage()));
        }
        finally {
            boolean isDeleted = zipFile.delete();
            if (!isDeleted) {
                String message = "fail to delete zipfile: " + zipFile;
                formView.showErrorNotification(message);
            }
        }
    }

    private static String getCodeLessRouteSqlName(Long id) {
        CodeLessRouteRepository codeLessRepository = CodeLessRouteRepository.getInstance();
        return ExportKsqlUtils.getSqlNamePrefix() + "code_less_" + codeLessRepository.findNumberByID(id).replace("/", "").replace("\\", "") + ".sql";
    }

    public static void exportKsqlRoute(List<Long> listIds, IFormView formView, String bankVersionID) {
        String zipName = ExportKsqlUtils.getZipName();
        File zipFile = new File(zipName);
        try {
            ArrayList<ZipTools.ZipParam> lstParam = new ArrayList<ZipTools.ZipParam>(16);
            List<Map<String, Object>> kSqls = ExportKsqlUtils.getRouteKSql(listIds);
            if (CollectionUtils.isEmpty(kSqls)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6ksql\u4e3a\u7a7a\u3002", (String)"ExportKsqlUtils_3", (String)"ebg-note-formplugin", (Object[])new Object[0]));
            }
            StringBuilder recordNoteXmlContent = new StringBuilder();
            StringBuilder recordFileListContent = new StringBuilder();
            recordNoteXmlContent.append(recordStart).append("\r\n").append(noteXmlRecordStart).append("\r\n");
            recordFileListContent.append(fileListRecordStart).append("\r\n");
            for (Map<String, Object> map : kSqls) {
                String fileName = bankVersionID + "/" + ExportKsqlUtils.getCodeLessRouteSqlName((Long)map.get("id"));
                String xmlSql = (String)map.get("sql");
                recordNoteXmlContent.append(recordNoteXmlPrefix).append(fileName).append(recordNoteXmlSuffix).append("\r\n");
                recordFileListContent.append(recordFileListPrefix).append(fileName).append("\r\n");
                ByteArrayInputStream sqlStream = new ByteArrayInputStream(xmlSql.getBytes(StandardCharsets.UTF_8));
                ZipTools.ZipParam param = new ZipTools.ZipParam();
                param.isfile = true;
                param.name = fileName;
                param.stream = sqlStream;
                lstParam.add(param);
            }
            ZipTools.zipStreams(lstParam, (File)zipFile);
        }
        catch (Exception var38) {
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"ExportKsqlUtils_4", (String)"ebg-note-formplugin", (Object[])new Object[0]), var38.getMessage()));
            return;
        }
        ExportKsqlUtils.downloadZipFile(formView, zipFile, zipName);
    }
}

