/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;

public final class JsonUtil {
    private static String space = "   ";

    public static <T> String toJson(T obj) {
        return JsonUtil.toJson(obj, false);
    }

    public static <T> String toJson(T obj, boolean pretty) {
        if (pretty) {
            return JSON.toJSONString(obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString(obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static String fromJson(String json) {
        StringBuilder result = new StringBuilder();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (JsonUtil.isEffectSpecChr(i, key, json)) {
                if (key == '[' || key == '{') {
                    result.append(key);
                    result.append('\n');
                    result.append(JsonUtil.indent(++number));
                    continue;
                }
                if (key == ']' || key == '}') {
                    result.append('\n');
                    result.append(JsonUtil.indent(--number));
                    result.append(key);
                    continue;
                }
                if (key == ',') {
                    result.append(key);
                    result.append('\n');
                    result.append(JsonUtil.indent(number));
                    continue;
                }
            }
            result.append(key);
        }
        return result.toString();
    }

    private static boolean isEffectSpecChr(int index, char key, String json) {
        boolean flag = false;
        boolean existLeft = false;
        if (JsonUtil.isDouMark(index, String.valueOf(key), json)) {
            existLeft = !existLeft;
        } else if (!(key != '[' && key != '{' && key != ']' && key != '}' && key != ',' || existLeft)) {
            flag = true;
        }
        return flag;
    }

    private static boolean isDouMark(int index, String key, String json) {
        if (key.equals("\"") && index >= 0) {
            if (index == 0) {
                return true;
            }
            char c = json.charAt(index - 1);
            if (c != '\\') {
                return true;
            }
        }
        return false;
    }

    private static String indent(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(space);
        }
        return result.toString();
    }

    public static <T> List<T> fromJsonArray(String jsonArray, Class<T> clazz) {
        return JSON.parseArray((String)jsonArray, clazz);
    }

    public static JSONObject toJsonObject(Object o) {
        return JSON.parseObject((String)JSON.toJSONString((Object)o));
    }
}

