/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.payable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.payable.cancle.QueryCancleImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class CanclePayableImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        LoginUtils.login();
        NotePayableInfo[] notePayableInfos = bankNotePayableRequest.getNotePayableInfosAsArray();
        String code = notePayableInfos[0].getOperationCode();
        if ("03".equals(code)) {
            code = "0002";
        } else if ("02".equals(code)) {
            code = "0001";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7968\u636e\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\uff1a%s\u3002", (String)"CanclePayableImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), code));
        }
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        NotePayableInfo info = notePayableInfos[0];
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN015", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData(common, "Bill_No", notePayableInfos[0].getBillNo());
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", "0");
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", "0");
        } else {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", info.getStartNo());
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", info.getEndNo());
        }
        JDomExtUtils.addChildCDData(common, "Bl_Udo_TpCd", code);
        JDomExtUtils.addChildCDData(common, "Aply_Psn_AccNo", acnt.getAccNo());
        JDomExtUtils.addChildCDData(common, "Bl_Aply_Psn_AccNm", acnt.getAccName());
        JDomExtUtils.addChildCDData(common, "Aply_Psn_DepBnk_BrNo", acnt.getCnaps());
        JDomExtUtils.addChildCDData(common, "Udo_Rsn", notePayableInfos[0].getExplanation());
        JDomExtUtils.addChildCDData(common, "Ori_Pltfrm_Dt", info.getBankRefDate());
        JDomExtUtils.addChildCDData(common, "Ori_Pltfrm_TrcNo", info.getBankRefKey());
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_SgnSl_MtdCd", "PS01");
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_Elc_Sgn", "");
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"CanclePayableImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            String BkListNo1 = response.getChildText("TxnSrlNo");
            EBGNotePayableUtils.setBatchNo((List)notePayableInfos, (String)BkListNo1);
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"CanclePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
        }
        return notePayableInfos;
    }
}

