/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.receivable.cancle.QueryReceiveCancleImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class CancleReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceiveCancleImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        LoginUtils.login();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        String code = receivableInfos[0].getOperationCode();
        if ("10".equals(code)) {
            code = "0003";
        } else if ("11".equals(code)) {
            code = "0004";
        } else if ("18".equals(code)) {
            code = "0005";
        } else if ("20".equals(code)) {
            code = "0007";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7968\u636e\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\uff1a%s\u3002", (String)"CancleReceivableImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), code));
        }
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        NoteReceivableInfo info = receivableInfos[0];
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN015", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData(common, "Bill_No", info.getBillNo());
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", "0");
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", "0");
        } else {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", info.getStartNo());
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", info.getEndNo());
        }
        JDomExtUtils.addChildCDData(common, "Bl_Txn_MsgRp_Src_Tp", "100003");
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_Elc_Sgn", "");
        JDomExtUtils.addChildCDData(common, "Bl_Prtc_SgnSl_MtdCd", "PS01");
        JDomExtUtils.addChildCDData(common, "Bl_Udo_TpCd", code);
        JDomExtUtils.addChildCDData(common, "Aply_Psn_AccNo", acnt.getAccNo());
        JDomExtUtils.addChildCDData(common, "Bl_Aply_Psn_AccNm", acnt.getAccName());
        JDomExtUtils.addChildCDData(common, "Aply_Psn_DepBnk_BrNo", acnt.getCnaps());
        JDomExtUtils.addChildCDData(common, "Udo_Rsn", info.getExplanation());
        JDomExtUtils.addChildCDData(common, "Ori_Pltfrm_Dt", info.getBankRefDate());
        JDomExtUtils.addChildCDData(common, "Ori_Pltfrm_TrcNo", info.getBankRefKey());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"CancleReceivableImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            String BkListNo1 = response.getChildText("TxnSrlNo");
            EBGNoteReceivableUtils.setNoteBatchNo((List)receivableInfos, (String)BkListNo1);
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"CancleReceivableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
        }
        return receivableInfos;
    }
}

