/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ksql.util.Base64;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.FileInfoNode;
import org.jdom2.Element;

public class NoteFileUtils
extends AbstractImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteFileUtils.class);
    public static String SEPARATOR = "|";
    private static String uploadFile = "upload";
    private static String LINESEPARTOR = "\n";

    public FileInfoNode getFileInfoNodes(String content, String fileName) {
        FileInfoNode node = new FileInfoNode();
        if (!StringUtils.isEmpty((String)content)) {
            node.setFileContent(content);
            try {
                String md5 = NoteFileUtils.getMD5(content, "UTF-8");
                node.setMd5(md5);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("\u5b57\u7b26\u96c6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u8f6c\u6362\u5931\u8d25\u3002", (String)"NoteFileUtils_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
            }
            node.setFileName(fileName);
        }
        return node;
    }

    public String uploadFile(FileInfoNode fileInfoNode) {
        try {
            String rqstStr = this.packUplaodFileXML(fileInfoNode);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parseUplaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String getMD5(String s, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        if (md5 != null) {
            md5.update(s.getBytes(encoding));
            for (byte b : md5.digest()) {
                sb.append(String.format("%02X", b));
            }
        }
        return sb.toString().toLowerCase();
    }

    private String packUplaodFileXML(FileInfoNode fileInfoNode) {
        Element simulator = JDomUtils.createRoot((String)"frontProxyRequst");
        Element head = NoteFileUtils.createHead(uploadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)"");
        JDomUtils.addChild((Element)body, (String)"fileName", (String)fileInfoNode.getFileName());
        JDomUtils.addChild((Element)body, (String)"bankFile", (String)fileInfoNode.getFileContent());
        JDomUtils.addChild((Element)body, (String)"fileEncoding", (String)"UTF-8");
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public static Element createHead(String bizType) {
        return NoteFileUtils.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("header");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        JDomUtils.addChild((Element)head, (String)"type", (String)bizType);
        return head;
    }

    private String sendAndRecvMsg(String rqstStr) {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_Port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        HttpConnection conn = new HttpConnection(ip, port, "", new HashMap(), timeOut);
        this.openConnection((IConnection)conn);
        String rspStr = null;
        try (OutputStream os = conn.getOutputStream();){
            this.send(os, rqstStr);
            try (InputStream is = this.getInputStream((IConnection)conn);){
                rspStr = this.recv(is);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }

    private String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = NoteFileUtils.parseHeader(root);
        if ("0001".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s %2$s", (String)"NoteFileUtils_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        String bankMsg = body.getChildText("bankMsg");
        try {
            bankMsg = new String(Base64.decode((String)bankMsg), RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u89e3\u78bc\u5931\u6557", (Throwable)e);
        }
        String[] strs = StringUtils.split((String)bankMsg, (String)"|");
        String flag = strs[0];
        String errorCodeString = strs[1];
        String errorMsg = strs[2];
        if (!"SUCCESS".equals(flag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s %2$s", (String)"NoteFileUtils_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), errorCodeString, errorMsg));
        }
        String fileMsg = strs[3];
        return fileMsg;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"header");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"returnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"NoteFileUtils_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"returnMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

