/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.codeless.detail.EndorseInfoImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class DetailInfoImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailInfoImpl.class);

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e0687";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u9762\u4fe1\u606f\u67e5\u8be2", (String)"DetailInfoImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteDetailRequest request, String s) {
        BankAcnt acnt = request.getAcnt();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)this.getBizCode());
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0687-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0687-rq");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)acnt.getAccNo());
            String transtype = "";
            String tranType = request.getBody().getTranType();
            if ("info".equals(request.getHeader().getSubBizType()) || "hold".equals(request.getHeader().getSubBizType())) {
                transtype = "I1";
            } else if ("02".equals(tranType)) {
                transtype = "A4";
            } else if ("03".equals(tranType)) {
                transtype = "A8";
            } else if ("10".equals(tranType)) {
                transtype = "C3";
            } else if ("20".equals(tranType)) {
                transtype = "G1";
            } else {
                this.logger.info("\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b" + tranType);
                throw new EBServiceException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b", (String)"DetailInfoImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)rq, (String)"querytype", (String)transtype);
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)request.getBody().getNoteNo());
            String subRange = request.getBody().getSubRange();
            if (StringUtils.isNotEmpty((String)subRange)) {
                subRange = subRange.replaceAll(",", "-");
                JDomUtils.addChild((Element)rq, (String)"scbintvl", (String)subRange);
            }
            JDomUtils.addChild((Element)rq, (String)"msgseq", (String)RequestContextUtils.getRunningParam((String)"msgseq"));
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String responseStr) {
        ArrayList<Detail> result = new ArrayList<Detail>(1);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0687-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (!("B001".equals(rspcod) || "B003".equals(rspcod) || "B002".equals(rspcod))) {
            throw EBExceiptionUtil.serviceException((String)rspmsg);
        }
        Element rs = trn.getChild("b2e0687-rs");
        List statusList = rs.getChildren("status");
        String another_rspCode = ((Element)statusList.get(0)).getChildTextTrim("rspcod");
        String another_rspMsg = ((Element)statusList.get(0)).getChildTextTrim("rspmsg");
        if (!another_rspCode.equals("B001")) {
            throw EBExceiptionUtil.serviceException((String)another_rspMsg);
        }
        String draftno = rs.getChildTextTrim("draftno");
        if (!draftno.equals(bankNoteDetailRequest.getBody().getNoteNo())) {
            throw EBExceiptionUtil.serviceException((String)"error note number");
        }
        String billStatus = ((Element)statusList.get(1)).getText();
        Detail info = new Detail();
        info.setNoteStatus(billStatus);
        String drafttype = rs.getChildTextTrim("drafttype");
        info.setDraftType(drafttype);
        String amount = rs.getChildTextTrim("amount");
        info.setAmount(amount);
        String date = rs.getChildTextTrim("date");
        info.setIssueDate(date);
        String duedate = rs.getChildTextTrim("duedate");
        info.setDueDate(duedate);
        String transferflg = rs.getChildTextTrim("transferflg");
        info.setTransferFlag(transferflg);
        String memo = rs.getChildTextTrim("memo");
        info.setRemark(memo);
        String scbintvl = rs.getChildTextTrim("scbintvl");
        info.setSubRange(scbintvl);
        String blcrclsts = rs.getChildTextTrim("blcrclsts");
        info.setCirStatus(blcrclsts);
        if (StringUtils.isNotEmpty((String)scbintvl) && scbintvl.contains("-")) {
            info.setGrdBag("1");
            String[] split = scbintvl.split("-");
            info.setStartNo(split[0]);
            info.setEndNo(split[1]);
        } else {
            info.setGrdBag("0");
        }
        Element drawee = rs.getChild("drawee");
        String actnam = drawee.getChildTextTrim("actnam");
        info.setDrawerAccName(actnam);
        String actacn = drawee.getChildTextTrim("actacn");
        info.setDrawerAccNo(actacn);
        String ibknum = drawee.getChildTextTrim("ibknum");
        info.setDrawerCnapsCode(ibknum);
        String bknm = drawee.getChildTextTrim("bknm");
        info.setDrawerBankName(bknm);
        Element acceptor = rs.getChild("acceptor");
        String acceptorCnapsCode = acceptor.getChildTextTrim("ibknum");
        info.setAcceptorCnapsCode(acceptorCnapsCode);
        String acceptorAccNo = acceptor.getChildTextTrim("actacn");
        info.setAcceptorAccNo(acceptorAccNo);
        String acceptorAccName = acceptor.getChildTextTrim("actnam");
        info.setAcceptorAccName(acceptorAccName);
        String acceptorBankName = acceptor.getChildTextTrim("bknm");
        info.setAcceptorBankName(acceptorBankName);
        Element toactn = rs.getChild("toactn");
        String payeeCnapsCode = toactn.getChildTextTrim("ibknum");
        info.setPayeeCnapsCode(payeeCnapsCode);
        String payeeAccNo = toactn.getChildTextTrim("actacn");
        info.setPayeeAccNo(payeeAccNo);
        String payeeName = toactn.getChildTextTrim("actnam");
        info.setPayeeAccName(payeeName);
        String payeeBankName = toactn.getChildTextTrim("bknm");
        info.setPayeeBankName(payeeBankName);
        info.setNoteNo(bankNoteDetailRequest.getBody().getNoteNo());
        Element endorseinfo = rs.getChild("endorseinfo");
        String edpname = endorseinfo.getChildText("edpname");
        String edpact = endorseinfo.getChildText("edpact");
        String edpbkn = endorseinfo.getChildText("edpbkn");
        String edpbknm = endorseinfo.getChildText("edpbknm");
        Element txinfo = rs.getChild("txinfo");
        String txractnm = txinfo.getChildText("txractnm");
        String txract = txinfo.getChildText("txract");
        String txrbkn = txinfo.getChildText("txrbkn");
        String txrbknm = txinfo.getChildText("txrbknm");
        Element payinfo = rs.getChild("payinfo");
        String reqactnm = payinfo.getChildText("reqactnm");
        String reqact = payinfo.getChildText("reqact");
        String eqbkm = payinfo.getChildText("eqbkm");
        String reqbkn = payinfo.getChildText("reqbkn");
        try {
            EndorseInfoImpl endorseInfo = new EndorseInfoImpl();
            EBBankDetailResponse message = endorseInfo.doBiz(bankNoteDetailRequest);
            info.setNoteSidesInfo(((Detail)message.getDetails().get(0)).getNoteSidesInfo());
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u5931\u8d25\uff0c\u7968\u53f7{}\uff0c\u5f02\u5e38\u4fe1\u606f{}", new Object[]{draftno, e.getMessage(), e});
            info.setIsNoteSidesError("Y");
        }
        if (!"hold".equals(bankNoteDetailRequest.getHeader().getSubBizType())) {
            String tranType = bankNoteDetailRequest.getBody().getTranType();
            if ("02".equals(tranType) || "03".equals(tranType)) {
                info.setApplicantAcName(actnam);
                info.setApplicantAcNo(actacn);
                info.setApplicantBankName(bknm);
                info.setApplicantBankCnaps(ibknum);
                info.setHolderAccNo(actacn);
                info.setPreHolderName(actnam);
                info.setHolderBankName(bknm);
                info.setHolderCnapsCode(ibknum);
            } else if ("10".equals(tranType)) {
                info.setApplicantAcName(edpname);
                info.setApplicantAcNo(edpact);
                info.setApplicantBankName(edpbknm);
                info.setApplicantBankCnaps(edpbkn);
                info.setHolderAccNo(edpact);
                info.setPreHolderName(edpname);
                info.setHolderBankName(edpbknm);
                info.setHolderCnapsCode(edpbkn);
            } else if ("11".equals(tranType)) {
                info.setApplicantAcName(txractnm);
                info.setApplicantAcNo(txract);
                info.setApplicantBankName(txrbknm);
                info.setApplicantBankCnaps(txrbkn);
                info.setHolderAccNo(txract);
                info.setPreHolderName(txractnm);
                info.setHolderBankName(txrbknm);
                info.setHolderCnapsCode(txrbkn);
            } else if ("20".equals(tranType)) {
                info.setApplicantAcName(reqactnm);
                info.setApplicantAcNo(reqact);
                info.setApplicantBankName(eqbkm);
                info.setApplicantBankCnaps(reqbkn);
                info.setHolderAccNo(reqact);
                info.setPreHolderName(reqactnm);
                info.setHolderBankName(eqbkm);
                info.setHolderCnapsCode(reqbkn);
            }
        }
        result.add(info);
        return result;
    }
}

