/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.login;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.boc.net.service.login.LoginPacker;
import kd.ebg.note.banks.boc.net.service.login.LoginParser;

public class LoginImpl
extends AbstractImpl {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private LoginPacker loginPacker = new LoginPacker();
    private LoginParser loginParser = new LoginParser();
    private String token;
    private static final int timeout = 900;

    public String getToken() {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get((String)key);
        if (StringUtils.isEmpty((String)cache_token)) {
            DLock lock = DLock.create((String)CosmicCache.getParentKey((String)key), (String)ResManager.loadKDString((String)"\u4e2d\u884c\u524d\u7f6e\u673a\uff08\u7b7e\u5230\uff09\u5206\u5e03\u5f0f\u9501", (String)"LoginImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            try {
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get((String)key);
                    if (cache_token == null) {
                        this.login();
                        CosmicCache.putIfAbsentWithExpire((String)key, (String)this.token, (int)900, (TimeUnit)TimeUnit.SECONDS);
                        cache_token = this.token;
                    }
                } else {
                    long time;
                    for (time = 180000L; time >= 0L && (cache_token = CosmicCache.get((String)key)) == null; time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"LoginImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return cache_token;
    }

    public void setTokenInvalid() {
        this.token = null;
    }

    private void login() {
        try {
            String rqstStr = this.loginPacker.packLogin();
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/B2EC/E2BServlet");
            IConnection conn = factory.createExchangeConnection();
            log.info("\u4e2d\u56fd\u94f6\u884c\u6267\u884c\u767b\u5f55[url:" + conn.getUrl() + "], \u8bf7\u6c42\u62a5\u6587\uff1a\n" + rqstStr);
            this.openConnection(conn);
            try (OutputStream outputStream = conn.getOutputStream();){
                this.send(outputStream, rqstStr);
                try (InputStream inputStream = conn.getInputStream();){
                    String rspStr = this.recv(inputStream);
                    this.token = this.loginParser.parseLogin(rspStr);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private String getCacheKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        return "eb_" + customID + "_" + bankLoginID + "_token";
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }
}

