/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.boc.net.service.note.util.NoteSendMsgHelper;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0102";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return "" + (Integer.parseInt(pageTag) + 50);
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0102-rs");
        if (trn == null) {
            return true;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        String totalnum = trn.getChildTextTrim("totalnum");
        if (StringUtils.isEmpty((String)totalnum)) {
            return true;
        }
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("B001".equals(rspcod) || "B003".equals(rspcod)) {
            return true;
        }
        if ("B002".equals(rspcod)) {
            return false;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25:%1$s %2$s", (String)"NoteDetailImpl_5", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), rspcod, rspmsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        BankNoteDetailRequestBody body = request.getBody();
        BankAcnt acnt = request.getAcnt();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            if ("info".equals(subBizType)) {
                String string = this.packerb2e0103("", "I1", request.getBody().getNoteNo(), request.getAcnt().getAccNo());
                return string;
            }
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0102");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0102-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0102-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)"");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)rq, (String)"payeeactn", (String)"");
            String tranType = request.getBody().getTranType();
            if ("hold".equals(subBizType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"I1");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"AP01");
            } else if ("02".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"A4");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            } else if ("03".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"A8");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            } else if ("10".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"C3");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            } else if ("20".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"G1");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            } else if ("19".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"E6");
                JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u9519\u8bef\uff1atranType=%s", (String)"NoteDetailImpl_6", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), tranType));
            }
            JDomUtils.addChild((Element)rq, (String)"drafttype", (String)body.getDraftType());
            JDomUtils.addChild((Element)rq, (String)"draweename", (String)"");
            JDomUtils.addChild((Element)rq, (String)"acceptorname", (String)"");
            JDomUtils.addChild((Element)rq, (String)"toname", (String)"");
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)"");
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)"");
            JDomUtils.addChild((Element)datescope, (String)"to", (String)"");
            Element duedatescope = JDomUtils.addChild((Element)rq, (String)"duedatescope");
            JDomUtils.addChild((Element)duedatescope, (String)"from", (String)"");
            JDomUtils.addChild((Element)duedatescope, (String)"to", (String)"");
            Element amountscope = JDomUtils.addChild((Element)rq, (String)"amountscope");
            JDomUtils.addChild((Element)amountscope, (String)"from", (String)"");
            JDomUtils.addChild((Element)amountscope, (String)"to", (String)"");
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)pageTag);
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)"50");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        String subBizType = request.getHeader().getSubBizType();
        if ("info".equals(subBizType)) {
            ArrayList<Detail> result = new ArrayList<Detail>(1);
            Detail info = this.parseMsg(responseStr, request, "", request.getAcnt().getAccNo());
            result.add(info);
            return result;
        }
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        BankNoteDetailRequestBody body = request.getBody();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0102-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        String totalnum = trn.getChildTextTrim("totalnum");
        if ("B999".equals(rspcod)) {
            return result;
        }
        if (!("B001".equals(rspcod) || "B003".equals(rspcod) || "B002".equals(rspcod))) {
            throw EBExceiptionUtil.serviceException((String)rspmsg);
        }
        List list = trn.getChildren("b2e0102-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            List statusAll = rs.getChildren("status");
            Element another_status = (Element)statusAll.get(0);
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            if (!"B001".equals(another_rspcod)) {
                String rspmsg1 = another_status.getChildTextTrim("rspmsg");
                throw EBExceiptionUtil.serviceException((String)rspmsg1);
            }
            String billStatus = ((Element)statusAll.get(1)).getText();
            if ("000000".equals(billStatus) || "000002".equals(billStatus)) continue;
            String msgseq = rs.getChildText("msgseq");
            String draftno = rs.getChildText("draftno");
            String transtype = null;
            if ("hold".equals(subBizType)) {
                transtype = "I1";
            } else if ("02".equals(request.getBody().getTranType())) {
                transtype = "A4";
            } else if ("03".equals(request.getBody().getTranType())) {
                transtype = "A8";
            } else if ("10".equals(request.getBody().getTranType())) {
                transtype = "C3";
            } else if ("19".equals(request.getBody().getTranType())) {
                transtype = "E6";
            } else if ("20".equals(request.getBody().getTranType())) {
                transtype = "G1";
            }
            String resultMsg = null;
            try {
                String reqMsg = this.packerb2e0103(msgseq, transtype, draftno, request.getAcnt().getAccNo());
                NoteSendMsgHelper helper = new NoteSendMsgHelper();
                resultMsg = helper.sendAndRecvMsg(reqMsg);
                Detail info = this.parseMsg(resultMsg, request, msgseq, request.getAcnt().getAccNo());
                result.add(info);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u5355\u7b14\u660e\u7ec6\u67e5\u8be2\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }

    private Detail parseMsg(String resultMsg, BankNoteDetailRequest request, String msgseq, String accNo) {
        Detail detailInfo = new Detail();
        Element root = JDomUtils.string2Root((String)resultMsg, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0103-rs");
        if (trn == null) {
            return null;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        if (!"B001".equals(rspcod)) {
            return null;
        }
        Element rs = trn.getChild("b2e0103-rs");
        List statusAll = rs.getChildren("status");
        Element status01 = (Element)statusAll.get(0);
        String another_rspcod = status01.getChildTextTrim("rspcod");
        if (!"B001".equals(another_rspcod)) {
            return null;
        }
        String draftno = rs.getChildTextTrim("draftno");
        String drafttype = rs.getChildTextTrim("drafttype");
        detailInfo.setNoteNo(draftno);
        detailInfo.setDraftType(drafttype);
        detailInfo.setBusinessCode(request.getBody().getTranType());
        String amount = rs.getChildTextTrim("amount");
        if (!StringUtils.isEmpty((String)msgseq)) {
            detailInfo.setBankRefKey(msgseq);
        }
        if (StringUtils.isEmpty((String)amount)) {
            detailInfo.setAmount(new BigDecimal("0").toString());
        } else {
            detailInfo.setAmount(new BigDecimal(amount).toString());
        }
        detailInfo.setNoteStatus(((Element)statusAll.get(1)).getText());
        String date = rs.getChildTextTrim("date");
        String duedate = rs.getChildTextTrim("duedate");
        if (date != null) {
            detailInfo.setIssueDate(date);
            detailInfo.setApplicationDate(date);
        }
        if (duedate != null) {
            detailInfo.setDueDate(duedate);
        }
        String transferflg = rs.getChildTextTrim("transferflg");
        detailInfo.setTransferFlag(transferflg);
        Element drawee = rs.getChild("drawee");
        String actnam = drawee.getChildText("actnam");
        String actacn = drawee.getChildText("actacn");
        String ibknum = drawee.getChildText("ibknum");
        String bknm = drawee.getChildText("bknm");
        detailInfo.setDrawerAccName(actnam);
        detailInfo.setDrawerAccNo(actacn);
        detailInfo.setDrawerBankName(bknm);
        detailInfo.setDrawerCnapsCode(ibknum);
        Element acceptor = rs.getChild("acceptor");
        String acc_actacn = acceptor.getChildText("actacn");
        String acc_actnam = acceptor.getChildText("actnam");
        String acc_bknum = acceptor.getChildText("ibknum");
        String acc_bknm = acceptor.getChildText("bknm");
        detailInfo.setAcceptorAccName(acc_actnam);
        detailInfo.setAcceptorAccNo(acc_actacn);
        detailInfo.setAcceptorBankName(acc_bknm);
        detailInfo.setAcceptorCnapsCode(acc_bknum);
        Element toactn = rs.getChild("toactn");
        String pee_actacn = toactn.getChildText("actacn");
        String pee_actnam = toactn.getChildText("actnam");
        String pee_ibknum = toactn.getChildText("ibknum");
        String pee_bknm = toactn.getChildText("bknm");
        detailInfo.setPayeeAccName(pee_actnam);
        detailInfo.setPayeeAccNo(pee_actacn);
        detailInfo.setPayeeBankName(pee_bknm);
        detailInfo.setPayeeCnapsCode(pee_ibknum);
        Element endorseinfo = rs.getChild("endorseinfo");
        String edpact = endorseinfo.getChildText("edpact");
        String edpname = endorseinfo.getChildText("edpname");
        String edpbkn = endorseinfo.getChildText("edpbkn");
        String edpbknm = endorseinfo.getChildText("edpbknm");
        detailInfo.setCurrency("CNY");
        String subBizType = request.getHeader().getSubBizType();
        if (!"hold".equals(subBizType)) {
            if (request.getBody().getTranType().equals("10")) {
                detailInfo.setApplicantAcName(edpname);
                detailInfo.setApplicantAcNo(edpact);
                detailInfo.setApplicantBankName(edpbknm);
                detailInfo.setApplicantBankCnaps(edpbkn);
            } else {
                detailInfo.setApplicantAcName(actnam);
                detailInfo.setApplicantAcNo(actacn);
                detailInfo.setApplicantBankName(bknm);
                detailInfo.setApplicantBankCnaps(ibknum);
            }
            detailInfo.setBusinessCode(request.getBody().getTranType());
        }
        try {
            this.logger.info("\u5f00\u59cb\u8fdb\u884c\u80cc\u4e66\u8054\u4fe1\u606f\u67e5\u8be2");
            EndorseInfoImpl endorseInfo = new EndorseInfoImpl();
            List<NoteSidesInfo> message = endorseInfo.getMessage(draftno, accNo);
            detailInfo.setNoteSidesInfo(message);
            this.logger.info("\u80cc\u4e66\u8054\u4fe1\u606f\u67e5\u8be2\u5b8c\u6210");
        }
        catch (Exception e) {
            this.logger.info(draftno + "\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u5931\u8d25\uff0c", (Object)e);
            detailInfo.setIsNoteSidesError("Y");
        }
        return detailInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String packerb2e0103(String msgseq, String transtype, String draftno, String accNo) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String msg;
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0103");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0103-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0103-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)"");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)accNo);
            JDomUtils.addChild((Element)rq, (String)"querytype", (String)transtype);
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)draftno);
            JDomUtils.addChild((Element)rq, (String)"msgseq", (String)msgseq);
            String string = msg = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            return this.doBizNoPage(request);
        }
        return this.doBizWithPage(request);
    }

    /*
     * Exception decompiling
     */
    public EBBankDetailResponse doBizNoPage(BankNoteDetailRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isNeedRetry(BankNoteDetailRequest request, String responseStr) {
        BankNoteDetailRequestBody body = request.getBody();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0102-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (!("B001".equals(rspcod) || "B003".equals(rspcod) || "B002".equals(rspcod))) {
            throw EBExceiptionUtil.serviceException((String)rspmsg);
        }
        List list = trn.getChildren("b2e0102-rs");
        Element rs1 = (Element)list.get(0);
        List statusAll1 = rs1.getChildren("status");
        if (statusAll1.size() > 0) {
            Element another_status1 = (Element)statusAll1.get(0);
            String another_rspcod1 = another_status1.getChildTextTrim("rspcod");
            String rspmsgother1 = another_status1.getChildTextTrim("rspmsg");
            if ("B999".equals(another_rspcod1) && StringUtils.isNotEmpty((String)rspmsgother1) && rspmsgother1.contains("CDS.MZZZ")) {
                return true;
            }
        }
        return false;
    }

    public EBBankDetailResponse doBizWithPage(BankNoteDetailRequest request) {
        ArrayList<Detail> list = new ArrayList<Detail>();
        ArrayList<Detail> listResult = new ArrayList<Detail>();
        HashMap<String, String> billKey = new HashMap<String, String>();
        try {
            String pageTag = this.getFirstPageTag();
            String responseStr = "";
            do {
                EBContext.getContext().setProcessFlag(PROCESS_PACK);
                String requestStr = this.pack(request, pageTag);
                EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection connection = this.getConnection(factory);
                this.openConnection(connection);
                EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
                try (OutputStream outputStream = this.getOutputStream(connection);){
                    this.send(outputStream, requestStr);
                    try (InputStream inputStream = this.getInputStream(connection);){
                        responseStr = this.recv(inputStream);
                        EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                        list.addAll(this.parse(request, responseStr));
                        pageTag = this.getNextPageTag(responseStr, pageTag);
                    }
                }
            } while (!this.isLastPage(responseStr, pageTag));
            for (Detail detail : list) {
                String noteno = detail.getNoteNo();
                if (!StringUtils.isNotEmpty((String)noteno)) continue;
                if (!billKey.containsKey(noteno)) {
                    billKey.put(noteno, noteno);
                    listResult.add(detail);
                    continue;
                }
                this.logger.info("billno  repeat" + noteno);
            }
            return new EBBankDetailResponse(listResult);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NoteDetailImpl_7", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38%s", (String)"NoteDetailImpl_8", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

