/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.payable.receive;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.payable.receive.QueryReceiveNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ReceiveNotePayableImpl
extends AbstractNotePayableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryReceiveNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968(b2e0108)", (String)"ReceiveNotePayableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNotePayableRequest request, String pageTag) {
        LoginAccess la = LoginAccessManager.searchLock();
        List infos = request.getNotePayableInfoList();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0108");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0108-rq");
            if (infos.size() > 50) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u8d85\u8fc750\u7b14\u3002", (String)"ReceiveNotePayableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            for (int i = 0; i < infos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0108-rq");
                JDomUtils.addChild((Element)rq, (String)"ibknum", (String)((NotePayableInfo)infos.get(i)).getDrawerBankCnaps());
                JDomUtils.addChild((Element)rq, (String)"actacn", (String)((NotePayableInfo)infos.get(i)).getDrawerAccNo());
                JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NotePayableInfo)infos.get(i)).getBillNo());
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"memo", (String)sequence);
                ((NotePayableInfo)infos.get(i)).setSequence(sequence);
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        List notePayableInfos = request.getNotePayableInfoList();
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0108-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0108-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element another_status = rs.getChild("status");
                String another_rspcod = another_status.getChildTextTrim("rspcod");
                String another_rspmsg = another_status.getChildTextTrim("rspmsg");
                String obssid = rs.getChildTextTrim("obssid");
                String draftno = rs.getChildTextTrim("draftno");
                for (NotePayableInfo notePayableInfo : notePayableInfos) {
                    notePayableInfo.setObssid(obssid);
                    if (!draftno.equals(notePayableInfo.getBillNo())) continue;
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return notePayableInfos;
    }
}

