/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.receivable.discount;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u7533\u8bf7(b2e0110)", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0110");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0110-rq");
            if (noteReceivableInfos.size() > 50) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u8d85\u8fc750\u7b14", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            BankAcnt acnt = request.getAcnt();
            for (int i = 0; i < noteReceivableInfos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0110-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
                JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBillNo());
                JDomUtils.addChild((Element)rq, (String)"rdstyp", (String)"RM00");
                if (((NoteReceivableInfo)noteReceivableInfos.get(i)).getDisCountRate() == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiscountNoteReceivableImpl_2", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                }
                BigDecimal b1 = new BigDecimal(((NoteReceivableInfo)noteReceivableInfos.get(i)).getDisCountRate());
                BigDecimal b2 = b1.divide(new BigDecimal(100), 6, 4);
                JDomUtils.addChild((Element)rq, (String)"rdsrat", (String)b2.toString());
                JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rq, (String)"onlflg", (String)("0".equals(((NoteReceivableInfo)noteReceivableInfos.get(0)).getAutoAccept()) ? "SM00" : "SM01"));
                JDomUtils.addChild((Element)rq, (String)"opndat", (String)"");
                JDomUtils.addChild((Element)rq, (String)"duedat", (String)"");
                JDomUtils.addChild((Element)rq, (String)"redrat", (String)"");
                JDomUtils.addChild((Element)rq, (String)"redamt", (String)"");
                JDomUtils.addChild((Element)rq, (String)"comnum", (String)"123");
                JDomUtils.addChild((Element)rq, (String)"invnum", (String)"123");
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"memo", (String)sequence);
                ((NoteReceivableInfo)noteReceivableInfos.get(i)).setSequence(sequence);
                JDomUtils.addChild((Element)rq, (String)"ratscl", (String)("0".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getIncreaseRate()) ? "" : ((NoteReceivableInfo)noteReceivableInfos.get(i)).getIncreaseRate()));
                String bustyp = "2";
                if ("3".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getDiscountType())) {
                    bustyp = "1";
                }
                JDomUtils.addChild((Element)rq, (String)"bustyp", (String)bustyp);
                Element entry = JDomUtils.addChild((Element)rq, (String)"entry");
                JDomUtils.addChild((Element)entry, (String)"toibkn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAcceptorBankCnaps());
                JDomUtils.addChild((Element)entry, (String)"actacn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAcceptorAccNo());
                Element inman = JDomUtils.addChild((Element)rq, (String)"inman");
                JDomUtils.addChild((Element)inman, (String)"inibkn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeBankCnaps());
                String payeeBankName = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeBankName();
                if (!StringUtils.isEmpty((String)payeeBankName) && payeeBankName.indexOf(ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-boc-net", (Object[])new Object[0])) != -1) {
                    JDomUtils.addChild((Element)inman, (String)"inactn", (String)"0");
                } else {
                    JDomUtils.addChild((Element)inman, (String)"inactn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeAccNo());
                }
                JDomUtils.addChild((Element)inman, (String)"incnam", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeAccName());
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0110-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0110-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element anotherStatus = rs.getChild("status");
                String another_rspcod = anotherStatus.getChildTextTrim("rspcod");
                String another_rspmsg = anotherStatus.getChildTextTrim("rspmsg");
                String obssid = rs.getChildTextTrim("obssid");
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setObssid(obssid);
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setBankRefKey(obssid);
                String draftno = rs.getChildTextTrim("draftno");
                for (NoteReceivableInfo info : noteReceivableInfos) {
                    if (!draftno.equals(info.getBillNo())) continue;
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return noteReceivableInfos;
    }
}

