/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.detail.endorseInfo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgParser;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class EndorseInfoImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseInfoImpl.class);

    public String packNoteInfoRequest(Detail info, BankAcnt ancAcnt) {
        JSONObject body = new JSONObject();
        String busCod = BankBusinessConfig.getBusMod(ancAcnt.getAccNo());
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        qryHdr.put("flwTyp", (Object)"ND0010");
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)ancAcnt.getAccNo().substring(0, 10));
        }
        qryHdr.put("oprAcc", (Object)ancAcnt.getAccNo());
        array1.add((Object)qryHdr);
        body.put("qryHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject BillQueryEdcInpDto = new JSONObject();
        BillQueryEdcInpDto.put("cltEac", (Object)ancAcnt.getAccNo());
        BillQueryEdcInpDto.put("bilNbr", (Object)info.getNoteNo());
        BillQueryEdcInpDto.put("bilSbs", (Object)info.getStartNo());
        BillQueryEdcInpDto.put("bilSbe", (Object)info.getEndNo());
        array2.add((Object)BillQueryEdcInpDto);
        body.put("BillQueryEdcInpDto", (Object)array2);
        JSONObject head = JsonUtil.getHead("bilinfqry", Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, "bilinfqry");
    }

    public List<NoteSidesInfo> getmessage(Detail info, BankAcnt ancAcnt) {
        ArrayList<NoteSidesInfo> list = new ArrayList(16);
        try {
            String rqstStr = this.packNoteInfoRequest(info, ancAcnt);
            String rspStr = PostUtil.sendMsgForPay(rqstStr);
            list = this.parserNoteInfoResponse(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return list;
    }

    public List<NoteSidesInfo> parserNoteInfoResponse(String rspStr) {
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>(16);
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray BillQueryEdcOutDto = body.getJSONArray("billQueryEdcOutDto");
        if (BillQueryEdcOutDto == null || BillQueryEdcOutDto.size() == 0) {
            return result;
        }
        JSONObject object = BillQueryEdcOutDto.getJSONObject(0);
        JSONArray billBehindInfoEdcDto = object.getJSONArray("billBehindInfoEdcDto");
        for (int i = 0; i < billBehindInfoEdcDto.size(); ++i) {
            JSONObject obiect = billBehindInfoEdcDto.getJSONObject(i);
            NoteSidesInfo detail = new NoteSidesInfo();
            String sndAcc = obiect.getString("sndAcc");
            detail.setInitiatorAcNo(sndAcc);
            String sndAcn = obiect.getString("sndAcn");
            detail.setInitiatorName(sndAcn);
            String rcvAcc = obiect.getString("rcvAcc");
            detail.setOpponentAcNo(rcvAcc);
            String rcvAcn = obiect.getString("rcvAcn");
            detail.setOpponentName(rcvAcn);
            String edrDat = obiect.getString("edrDat");
            detail.setSignDate(edrDat);
            detail.setResv1(billBehindInfoEdcDto.size() - i + "");
            result.add(detail);
        }
        logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }
}

