/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.receivable.discount;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.receivable.cancle.CancleNoteReceivableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.AvaiableQuery;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgParser;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "discount";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NoteReceivableInfo> infos = this.parse(request, rspStr);
            return new EBBankNoteReceivableResponse(infos);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNoteReceivableResponse(request.getNoteReceivableInfos());
        }
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        NoteReceivableInfo[] receivableInfos = request.getNotePayableInfosAsArray();
        AvaiableQuery avaiable = new AvaiableQuery();
        String startNo = receivableInfos[0].getStartNo();
        String endNo = receivableInfos[0].getEndNo();
        Map flag = avaiable.getmsg(receivableInfos[0].getDrawerAccNo(), "BC08", receivableInfos[0].getBillNo(), startNo, endNo);
        if (flag == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6b64\u7968\u636e\u4e0d\u80fd\u8d34\u73b0\u3002", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        String flwCod = BankBusinessConfig.getBusMod(receivableInfos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u666e\u901a\u8d34\u73b0\u7533\u8bf7discount\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u7ef4\u62a4\u3002", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"FA");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"02");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"OUT");
        cltTrsDetailEdcInpDto.put("busStr", (Object)receivableInfos[0].getDraftType());
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)receivableInfos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("trsAmt", (Object)receivableInfos[0].getAmount().toString());
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("busOprX1", (Object)array2);
        JSONArray array3 = new JSONArray();
        JSONObject DiscountApplyX1 = new JSONObject();
        array3.add((Object)DiscountApplyX1);
        body.put("DiscountApplyX1", (Object)array3);
        DiscountApplyX1.put("appEac", (Object)acnt.getAccNo());
        DiscountApplyX1.put("opcNam", (Object)receivableInfos[0].getPayeeBankName());
        DiscountApplyX1.put("opcBrd", (Object)receivableInfos[0].getPayeeBankCnaps());
        DiscountApplyX1.put("appSrc", (Object)"CS02");
        DiscountApplyX1.put("busTyp", (Object)"DSC0");
        DiscountApplyX1.put("busDat", (Object)DateUtil.formatDate((Date)new Date()));
        DiscountApplyX1.put("prxApp", (Object)"PS01");
        DiscountApplyX1.put("busCcy", (Object)"10");
        DiscountApplyX1.put("busAmt", (Object)receivableInfos[0].getAmount().toString());
        DiscountApplyX1.put("busCnt", (Object)"1");
        DiscountApplyX1.put("bilShp", (Object)"E");
        DiscountApplyX1.put("bilTyp", (Object)receivableInfos[0].getDraftType());
        DiscountApplyX1.put("trfFlg", (Object)"EM00");
        DiscountApplyX1.put("dvpFlg", (Object)"ST01");
        DiscountApplyX1.put("accEac", (Object)receivableInfos[0].getAcceptorAccNo());
        DiscountApplyX1.put("accBrd", (Object)receivableInfos[0].getAcceptorBankCnaps());
        DiscountApplyX1.put("dscInr", (Object)receivableInfos[0].getDisCountRate());
        DiscountApplyX1.put("dscTyp", (Object)"RM00");
        if ("1".equals(receivableInfos[0].getDiscountType())) {
            DiscountApplyX1.put("pinFlg", (Object)"BG");
            DiscountApplyX1.put("pinPct", (Object)"0");
        } else if ("2".equals(receivableInfos[0].getDiscountType())) {
            DiscountApplyX1.put("pinFlg", (Object)"VD");
            DiscountApplyX1.put("pinPct", (Object)"100");
        } else if ("3".equals(receivableInfos[0].getDiscountType())) {
            DiscountApplyX1.put("pinFlg", (Object)"AG");
            DiscountApplyX1.put("pinPct", (Object)receivableInfos[0].getIncreaseRate());
        }
        DiscountApplyX1.put("bilSbs", (Object)startNo);
        DiscountApplyX1.put("bilSbe", (Object)endNo);
        DiscountApplyX1.put("subAmt", (Object)receivableInfos[0].getAmount().toString());
        DiscountApplyX1.put("busCod", (Object)"BC08");
        JSONArray array4 = new JSONArray();
        JSONObject DiscountApplyX2 = new JSONObject();
        array4.add((Object)DiscountApplyX2);
        body.put("DiscountApplyX2", (Object)array4);
        DiscountApplyX2.put("bilNbr", (Object)receivableInfos[0].getBillNo());
        DiscountApplyX2.put("bilSbs", (Object)startNo);
        DiscountApplyX2.put("bilSbe", (Object)endNo);
        DiscountApplyX2.put("subAmt", (Object)receivableInfos[0].getAmount().toString());
        JSONObject head = JsonUtil.getHead("discount", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, logger, "discount");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rsp) {
        DiscountNoteReceivableImpl.parsePay(request.getNoteReceivableInfos(), rsp);
        return request.getNoteReceivableInfos();
    }

    public static void parsePay(List<NoteReceivableInfo> receivableInfos, String rspStr) {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"ParserReceivable_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if ("EA8GL65".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (!"SUC0000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray batchBusOprZ1 = body.getJSONArray("busOprZ1");
        JSONObject object = batchBusOprZ1.getJSONObject(0);
        String bchSts = object.getString("bchSts");
        String rjcCod = object.getString("rjcCod");
        String rjcRsn = object.getString("rjcRsn");
        if (!StringUtils.isEmpty((String)rjcCod) && !"SUC0000".equals(rjcCod)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rjcCod, (String)rjcRsn);
        } else {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)bchSts, (String)"");
        }
    }
}

