/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.util;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonFormat;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SMUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SignWithAES;
import kd.ebg.note.banks.cmb.opa.service.note.util.SignWithRSA;

public class MsgPacker {
    public static String getSendMsg(JSONObject object, EBGLogger logger, String bizCode) {
        EBContext.getContext().setType("request");
        String orgi = JsonUtil.serialJsonOrdered(object);
        try {
            logger.info("\u539f\u59cb\u6570\u636e\uff1a" + JsonFormat.formatJson(orgi));
        }
        catch (Throwable t) {
            logger.info("\u539f\u59cb\u6570\u636e\uff1a" + orgi);
        }
        if (BankBusinessConfig.isPreCloud()) {
            return MsgPacker.getFormParam(orgi, false, bizCode, logger);
        }
        boolean isSM = "SM".equalsIgnoreCase(RequestContextUtils.getBankParameterValue((String)"sign_type"));
        String signstr = isSM ? SMUtil.signUser(orgi) : SignWithRSA.encryptAES256Str(orgi);
        String content = "";
        if (!BankBusinessConfig.isSaasCloud()) {
            content = JsonUtil.getFinallyStr(object, signstr);
        } else {
            String plateFormSignStr = SMUtil.signKingdee(signstr);
            logger.info("\u5e73\u53f0\u7b7e\u540d\u540e\u6570\u636e\uff1a" + plateFormSignStr);
            content = JsonUtil.getPlateFromFinallyStr(object, signstr, plateFormSignStr);
        }
        logger.info("\u5c01\u88c5\u5e73\u53f0\u7b7e\u540d\u6570\u636e\uff1a" + content);
        String result = isSM ? SMUtil.encrypt(content) : SignWithAES.encryptAES256Str(content);
        HashMap<String, String> map = new HashMap<String, String>(16);
        String encoding = RequestContextUtils.getCharset();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        if (isSM) {
            map.put("ALG", "SM");
        }
        if (StringUtils.isNotEmpty((String)bizCode)) {
            map.put("FUNCODE", bizCode);
        }
        try {
            map.put("DATA", URLEncoder.encode(result, encoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String param = MsgPacker.createLinkString(map);
        return param;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        char eqs = '=';
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                prestr.append(key).append(eqs).append(value);
                continue;
            }
            prestr.append(key).append(eqs).append(value).append('&');
        }
        return prestr.toString();
    }

    private static String getFormParam(String param, boolean isSM, String bizCode, EBGLogger logger) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String encoding = RequestContextUtils.getCharset();
        String loginName = RequestContextUtils.getBankParameterValue((String)"lgnnam");
        map.put("UID", loginName);
        if (BankBusinessConfig.isSaasCloud()) {
            map.put("INSPLAT", "KINGDEE");
        }
        if (isSM) {
            map.put("ALG", "SM");
        }
        if (StringUtils.isNotEmpty((String)bizCode)) {
            map.put("FUNCODE", bizCode);
        }
        try {
            map.put("DATA", URLEncoder.encode(param, encoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = MsgPacker.createLinkString(map);
        return result;
    }
}

