/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgParser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;

public class ParserPayable {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParserPayable.class);

    public static void parsePay(List<NotePayableInfo> notePayableInfos, String rspStr) throws EBServiceException {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s", (String)"ParserPayable_6", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if ("WAE0009".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos.get(0), (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%1$s\u3002", (String)"ParserPayable_4", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray batchBusOprZ1 = body.getJSONArray("batchBusOprZ1");
        JSONObject object = batchBusOprZ1.getJSONObject(0);
        String bchSts = object.getString("bchSts");
        String rjcCod = object.getString("rjcCod");
        String rjcRsn = object.getString("rjcRsn");
        String bchKey = object.getString("bchKey");
        notePayableInfos.get(0).setBankRefKey(bchKey);
        if (!StringUtils.isEmpty((String)rjcCod) && !"SUC0000".equals(rjcCod)) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos.get(0), (PaymentState)PaymentState.UNKNOWN, (String)rjcCod, (String)rjcRsn);
        } else {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos.get(0), (PaymentState)PaymentState.SUBMITED, (String)bchSts, (String)"");
        }
    }

    public static void parseBnkbilnegqry(List<NotePayableInfo> infos, String rspStr) {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s", (String)"ParserPayable_6", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790Bnkbilnegqry\u65f6\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%1$s\u3002", (String)"ParserPayable_5", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray comQryZ1 = body.getJSONArray("comQryZ1");
        if (comQryZ1 == null || comQryZ1.size() == 0) {
            return;
        }
        JSONObject object = comQryZ1.getJSONObject(0);
        JSONObject rtnDta = object.getJSONObject("rtnDta");
        if (rtnDta == null) {
            return;
        }
        JSONArray data = rtnDta.getJSONArray("data");
        if (data == null || data.size() == 0) {
            return;
        }
        JSONObject result = data.getJSONObject(0);
        String orgName = result.getString("brnNbr");
        String textNo = result.getString("textNo");
        infos.get(0).setReserved1(orgName);
        infos.get(0).setContractNo(textNo);
    }

    public static void parsePayResult(List<NotePayableInfo> infos, String rspStr) throws EBServiceException {
        if (rspStr.contains("ErrMsg")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s", (String)"ParserPayable_6", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), rspStr));
        }
        String res = MsgParser.getReceMsg(rspStr, logger);
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%1$s\u3002", (String)"ParserPayable_4", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray cltTrsDetailEdcOutDto = body.getJSONArray("cltTrsDetailEdcOutDto");
        if (cltTrsDetailEdcOutDto == null || cltTrsDetailEdcOutDto.size() == 0) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"");
            return;
        }
        JSONObject DTO = cltTrsDetailEdcOutDto.getJSONObject(cltTrsDetailEdcOutDto.size() - 1);
        JSONObject intSrchZ1 = DTO.getJSONObject("intSrchZ1");
        if (intSrchZ1 == null) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"");
            return;
        }
        String oprStp = intSrchZ1.getString("oprStp");
        String rstFlg = intSrchZ1.getString("rstFlg");
        String rjcCod = intSrchZ1.getString("rjcCod");
        String rjcRsn = intSrchZ1.getString("rjcRsn");
        String finFlg = intSrchZ1.getString("finFlg");
        String busSts = intSrchZ1.getString("busSts");
        String prcSts = intSrchZ1.getString("prcSts");
        if ("N".equals(finFlg)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ParserPayable_7", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            return;
        }
        JSONObject billFrontInfo = DTO.getJSONObject("billFrontInfoEdcDto");
        if (billFrontInfo == null) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)oprStp, (String)ResManager.loadKDString((String)"billFrontInfoEdcDto\u4e3a\u7a7a\uff0c\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"ParserPayable_9", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            return;
        }
        String bilNbr = billFrontInfo.getString("bilNbr");
        infos.get(0).setBillNo(bilNbr);
        String bilSbs = billFrontInfo.getString("bilSbs");
        infos.get(0).setStartNo(bilSbs);
        String bilSbe = billFrontInfo.getString("bilSbe");
        infos.get(0).setEndNo(bilSbe);
        String bilSts = billFrontInfo.getString("bilSts");
        infos.get(0).setNoteStatus(bilSts);
        String trdSts = billFrontInfo.getString("trdSts");
        infos.get(0).setCirStatus(trdSts);
        infos.get(0).setSubRange(bilSbs + "-" + bilSbe);
        if ("OPR".equals(prcSts) || "AUT".equals(prcSts) || "NTE".equals(prcSts) || "BNK".equals(prcSts)) {
            if ("note_cancle".equals(infos.get(0).getSubBizType())) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ParserPayable_7", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else if ("CS01".equals(bilSts) && "TF0302".equals(trdSts)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536\u3002\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"ParserPayable_10", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else if ("CS01".equals(bilSts) && "TF0101".equals(trdSts)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\uff1a\u51fa\u7968\u5df2\u767b\u8bb0\u3002\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"ParserPayable_11", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else if ("CS02".equals(bilSts) && "TF0101".equals(trdSts)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536\u3002\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"ParserPayable_12", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else if ("CS02".equals(bilSts) && "TF0302".equals(trdSts)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u3002\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"ParserPayable_13", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else if ("CS03".equals(bilSts) && "TF0301".equals(trdSts)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536\u3002\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"ParserPayable_14", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ParserPayable_7", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            }
        } else if (StringUtils.isEmpty((String)rstFlg)) {
            JSONObject cltTrsDetailInfoDto = DTO.getJSONObject("cltTrsDetailInfoDto");
            if (cltTrsDetailInfoDto != null) {
                String busSts2 = cltTrsDetailInfoDto.getString("busSts");
                if ("note_cancle".equals(infos.get(0).getSubBizType()) && "SY".equals(busSts2)) {
                    infos.get(0).setCirStatus("TF0301");
                    EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)rstFlg, (String)"");
                }
            } else {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)oprStp, (String)rstFlg);
            }
        } else if ("S".equals(rstFlg)) {
            if ("remit_register".equals(infos.get(0).getSubBizType())) {
                if ("CS03".equals(bilSts) && "TF0301".equals(trdSts)) {
                    EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)rstFlg, (String)"");
                }
            } else {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)rstFlg, (String)"");
            }
        } else if ("F".equals(rstFlg) || "R".equals(rstFlg) || "C".equals(rstFlg) || "T".equals(rstFlg) || "D".equals(rstFlg)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)rstFlg, (String)rjcRsn);
        } else {
            JSONObject cltTrsDetailInfoDto = DTO.getJSONObject("cltTrsDetailInfoDto");
            if (cltTrsDetailInfoDto != null) {
                String busSts2 = cltTrsDetailInfoDto.getString("busSts");
                String ansCod = cltTrsDetailInfoDto.getString("ansCod");
                if ("remit_register".equals(infos.get(0).getSubBizType()) && "SU01".equals(ansCod) && "SA".equals(busSts2)) {
                    EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)rjcCod, (String)rjcRsn);
                }
            }
        }
    }
}

