/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.payable.cancle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.payable.cancle.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u7533\u8bf7\u64a4\u56de(P70106)", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        for (int i = 0; i < infos.length; ++i) {
            NotePayableInfo info = infos[i];
            JSONObject object = new JSONObject();
            reqInfoList.add((Object)object);
            object.put("applAcctNo", (Object)info.getDrawerAccNo());
            String billId_hldrId = info.getBankRefKey();
            String[] bankRefKey = billId_hldrId.split("_");
            if (bankRefKey.length < 4) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u64a4\u9500bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"CancleNotePayableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
            object.put("transId", (Object)bankRefKey[2]);
            object.put("msgId", (Object)bankRefKey[3]);
            object.put("reserveFlag", (Object)"0");
            object.put("rmrkByPropsr", (Object)info.getExplanation());
        }
        return PackerUtil.getPackerResult(root.toJSONString(), "P70106");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String rspStr) {
        List infos = request.getNotePayableInfoList();
        JSONObject retData = ParserUtil.getJsonRoot(rspStr);
        String retCode = retData.getString("retCode");
        if (!"000000".equals(retCode)) {
            String retMsg = retData.getString("retMsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)retCode, (String)retMsg);
        } else {
            JSONObject content = retData.getJSONObject("retData");
            JSONArray list = content.getJSONArray("list");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject object = (JSONObject)list.get(i);
                NotePayableInfo info = (NotePayableInfo)infos.get(0);
                if (info == null) continue;
                String billId = object.getString("billId");
                String hldrId = object.getString("hldrId");
                String transId = object.getString("transId");
                info.setReserved1(billId);
                info.setReserved2(hldrId);
                info.setReserved3(transId);
                info.setBankRefKey(billId + '_' + hldrId);
                if (StringUtils.isEmpty((String)transId)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e0d\u5168\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\uff0c\u8bf7\u7ebf\u4e0b\u786e\u8ba4", (String)"CancleNotePayableImpl_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"CancleNotePayableImpl_3", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
        }
        return infos;
    }
}

