/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.payable.register;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.QueryUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70109";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u67e5\u8be2", (String)"QueryRegisterNotePayableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        if (StringUtils.isEmpty((String)infos[0].getReserved4())) {
            return QueryUtil.packerPayable(infos);
        }
        JSONObject root = new JSONObject();
        JSONObject pageInfo = new JSONObject();
        pageInfo.put("pageNo", (Object)"1");
        pageInfo.put("pageSize", (Object)"100");
        root.put("pageInfo", (Object)pageInfo);
        JSONObject requestDto = new JSONObject();
        root.put("requestDto", (Object)requestDto);
        NotePayableInfo info = infos[0];
        requestDto.put("applAcctNo", (Object)info.getDrawerAccNo());
        requestDto.put("billNo", (Object)info.getBillNo());
        requestDto.put("applyQueryType", (Object)"1");
        requestDto.put("transType", (Object)"1");
        requestDto.put("dataSource", (Object)"1");
        root.put("dataSource", (Object)"1");
        return PackerUtil.getPackerResult(root.toJSONString(), "P70109");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String respStr) {
        List infos = request.getNotePayableInfoList();
        JSONObject retData = ParserUtil.getJsonRoot(respStr);
        String retCode = retData.getString("retCode");
        if (!"000000".equals(retCode)) {
            String retMsg = retData.getString("retMsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)retMsg);
        } else {
            JSONObject content = retData.getJSONObject("retData");
            JSONArray list = content.getJSONArray("list");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject object = (JSONObject)list.get(i);
                String billId = object.getString("billId");
                String hldrId = object.getString("hldrId");
                NotePayableInfo info = (NotePayableInfo)infos.get(0);
                info.setBankRefKey(billId + '_' + hldrId);
                if (info == null) continue;
                String billNo = object.getString("billNo");
                info.setBillNo(billNo);
                String transNo = object.getString("transNo");
                String billRangeStart = object.getString("billRangeStart");
                info.setStartNo(billRangeStart);
                String billRangeEnd = object.getString("billRangeEnd");
                info.setEndNo(billRangeEnd);
                String billStatus = object.getString("billStatus");
                info.setNoteStatus(billStatus);
                String cirStatus = object.getString("cirStatus");
                info.setCirStatus(cirStatus);
                String transStatus = object.getString("transBusiStatus");
                info.setSubRange(billRangeStart + "-" + billRangeEnd);
                if (info.getAutoAccept().equals("1") && info.getAutoReceive().equals("1") && info.getSubBizType().equals("remit_register")) {
                    if (StringUtils.isEmpty((String)info.getReserved1())) {
                        if (!"NES.001.20.00P".equals(transNo)) {
                            continue;
                        }
                    } else if (!"register".equals(info.getReserved1()) ? "accept".equals(info.getReserved1()) && !"NES.003.20.00P".equals(transNo) : !"NES.002.20.00P".equals(transNo)) continue;
                    if ("CS01".equals(billStatus) && "TF0302".equals(cirStatus)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536\uff0c\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"QueryRegisterNotePayableImpl_5", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    } else if ("CS01".equals(billStatus) && "TF0101".equals(cirStatus)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\uff1a\u51fa\u7968\u5df2\u767b\u8bb0\uff0c\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"QueryRegisterNotePayableImpl_6", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                        info.setReserved1("register");
                    } else if ("CS02".equals(billStatus) && "TF0101".equals(cirStatus)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536\uff0c\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"QueryRegisterNotePayableImpl_7", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                        info.setReserved1("accept");
                    } else if ("CS02".equals(billStatus) && "TF0302".equals(cirStatus)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\uff1a\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\uff0c\u4e09\u8054\u52a8\u51fa\u7968\uff0c\u8bf7\u7ee7\u7eed\u540c\u6b65\u7968\u636e\u72b6\u6001", (String)"QueryRegisterNotePayableImpl_8", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    } else if ("CS03".equals(billStatus) && "TF0301".equals(cirStatus)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    }
                    String statusCode = object.getString("statusCode");
                    if (!"3".equals(statusCode)) continue;
                    String errorMsg = object.getString("errorMsg");
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)transStatus, (String)errorMsg);
                    continue;
                }
                if ("TBS23".equals(transStatus) || "TBS37".equals(transStatus) || "TBS21".equals(transStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("TBS31".equals(transStatus) || "TBS33".equals(transStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("TBS11".equals(transStatus) || "TBS12".equals(transStatus) || "TBS13".equals(transStatus) || "TBS14".equals(transStatus) || "TBS15".equals(transStatus) || "TBS16".equals(transStatus) || "TBS17".equals(transStatus) || "TBS18".equals(transStatus) || "TBS19".equals(transStatus)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"QueryRegisterNotePayableImpl_3", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)transStatus, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"QueryRegisterNotePayableImpl_4", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

