/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.note.banks.cib.dc.services.CIB_DC_Notepc_QueryPayPacker;
import kd.ebg.note.banks.cib.dc.services.util.FileUtil;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.common.utils.FileStorageUtil;
import netbank.firm.service.FileService;

public class Common
extends AbstractImpl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CIB_DC_Notepc_QueryPayPacker.class);
    public static Map<String, String> appDateMap = new ConcurrentHashMap<String, String>();
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isSameBank(String bankName, String bankVersionId) {
        logger.info("\u6821\u9a8c\u662f\u5426\u662f\u540c\u884c\u65f6\u5165\u53c2\uff1abankName=" + bankName + ",bankVersionId=" + bankVersionId);
        boolean isSameBank = false;
        if (SameBankUtil.isSameBank((String)bankVersionId, (String)bankName).equals("1")) {
            isSameBank = true;
        }
        return isSameBank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String findAppDate(String billNo) {
        FileInputStream in = null;
        try {
            String appDate;
            Properties prop = new Properties();
            in = new FileInputStream(Common.getFile());
            prop.load(in);
            String string = appDate = prop.getProperty(billNo).trim();
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void insertAppDate(String billNo, String appDate) {
        FileInputStream in = null;
        try (FileOutputStream fos = new FileOutputStream("appDate.properties");){
            Properties prop = new Properties();
            in = new FileInputStream(Common.getFile());
            prop.load(in);
            prop.setProperty(billNo, appDate);
            prop.store(fos, "insert [key:" + billNo + ", value:" + appDate + "]");
            fos.close();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deletAppDate(String billNo) {
        FileInputStream in = null;
        try (FileOutputStream fos = new FileOutputStream("appDate.properties");){
            Properties prop = new Properties();
            in = new FileInputStream(Common.getFile());
            prop.load(in);
            if (billNo != null) {
                prop.remove(billNo);
            }
            prop.store(fos, "delet [key:" + billNo + "]");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u4e1a\u52a1\u65f6\u95f4\u5f02\u5e38" + e);
            }
        }
    }

    private static File getFile() throws IOException {
        boolean flag;
        File file = new File("./appDate.properties");
        if (!file.exists() && !(flag = file.createNewFile())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\u3002", (String)"Common_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        return file;
    }

    public static String downloadFileFromBank2(String fileName, String fileId) throws Exception {
        logger.info("\u4ece\u94f6\u884c\u4e0b\u8f7d\u6587\u4ef6\uff1a\u65b9\u5f0f\u4e00");
        FileService service = new FileService();
        Properties properties = new Properties();
        IParameter parameter = EBContext.getContext().getParameter();
        String path = FileStorageUtil.getStorageRootPath();
        logger.info("\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\uff1a" + path);
        int port = Integer.parseInt(parameter.getBankParameter("fileport"));
        logger.info("\u4ece\u94f6\u884c\u4e0b\u8f7d\u6587\u4ef6");
        return Common.downloadFile(fileName, fileId, parameter.getBankParameter("ip"), port, path);
    }

    private static String downloadFile(String fileName, String fileId, String ip, int filePort, String fileReceivePath) {
        FileUtil fileUtil = new FileUtil();
        String path = "";
        try {
            path = fileUtil.downloadFile(fileName, fileId, ip, filePort, fileReceivePath);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef:", (String)"Common_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return path;
    }

    public String downloadFileFromBank3(String fileName, String fileId) throws Exception {
        logger.info("\u4ece\u94f6\u884c\u4e0b\u8f7d\u6587\u4ef6\uff1aAPI\u6587\u4ef6\u4e0b\u8f7d\u65b9\u5f0f");
        String filePath = "";
        try {
            String paramUrl = "/download?fileId=" + URLEncoder.encode(fileId, RequestContextUtils.getCharset()) + "&fileName=" + URLEncoder.encode(fileName, RequestContextUtils.getCharset());
            filePath = this.downLoadFileFromBankApi(paramUrl, fileId + "_" + fileName);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
        return filePath;
    }

    public String downLoadFileFromBankApi(String paramUrl, String fileName) throws Exception {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        String portStr = RequestContextUtils.getBankParameterValue((String)"fileport");
        String filePath = RequestContextUtils.getBankParameterValue((String)"contractPath");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        logger.info("\u5f00\u59cb\u6587\u4ef6\u4e0b\u8f7d\uff0c\u4e0b\u8f7d\u5730\u5740\u4e3a\uff1a" + ip + ":" + portStr + paramUrl);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Request Method", "GET");
        HttpConnection conn = new HttpConnection(ip, port, paramUrl, header, timeOut);
        this.openConnection((IConnection)conn);
        try (InputStream is = this.getInputStream((IConnection)conn);){
            File saveDir = FileCommonUtils.getFileByPath((String)filePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(filePath + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(this.readInputStream(is));
            }
            this.closeInputStreamQuietly(is);
            logger.info("\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff01");
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)"file download error");
        }
        return filePath + File.separator + fileName;
    }

    public byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        FileInputStream fis = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            fis = new FileInputStream(file);
            byte[] buffer = new byte[2048];
            int length = -1;
            long s = System.currentTimeMillis();
            while ((length = fis.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            byte[] b = md.digest();
            String string = Common.byteToHexString(b);
            return string;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    private static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        String s = new String(str);
        return s;
    }
}

