/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote;

import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class NoteHandlerHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NoteHandlerHelper.class);

    public static String getIsPrmtSubpge(NotePayableInfo info) {
        String grdBag = info.getGrdBag();
        if ("1".equals(grdBag)) {
            return "Y";
        }
        if ("0".equals(grdBag)) {
            return "N";
        }
        return "N";
    }

    public static String getFixSubBillRng(NotePayableInfo info) {
        String startNo = info.getStartNo();
        String engNo = info.getEndNo();
        String grdBag = info.getGrdBag();
        if (!"1".equals(grdBag)) {
            return "0";
        }
        if (StringUtils.isNotEmpty((String)info.getSubRange())) {
            String[] subs = info.getSubRange().split(",");
            return NoteHandlerHelper.formatLen(subs[0], 12) + "," + NoteHandlerHelper.formatLen(subs[1], 12);
        }
        if (StringUtils.isEmpty((String)startNo) || StringUtils.isEmpty((String)engNo)) {
            return "0";
        }
        return NoteHandlerHelper.formatLen(startNo, 12) + "," + NoteHandlerHelper.formatLen(engNo, 12);
    }

    public static String getFixSubBillRng(NoteReceivableInfo info) {
        String startNo = info.getStartNo();
        String engNo = info.getEndNo();
        String grdBag = info.getGrdBag();
        if (!"1".equals(grdBag)) {
            return "0";
        }
        if (StringUtils.isNotEmpty((String)info.getSubRange())) {
            String[] subs = info.getSubRange().split(",");
            return NoteHandlerHelper.formatLen(subs[0], 12) + "," + NoteHandlerHelper.formatLen(subs[1], 12);
        }
        if (StringUtils.isEmpty((String)startNo) || StringUtils.isEmpty((String)engNo)) {
            return "0";
        }
        return NoteHandlerHelper.formatLen(startNo, 12) + "," + NoteHandlerHelper.formatLen(engNo, 12);
    }

    public static String getStartNo(String BillNoRng, String spMark) {
        String[] subRange = BillNoRng.split(spMark);
        if (subRange.length > 1) {
            return subRange[0];
        }
        return "0";
    }

    public static String getEndNo(String BillNoRng, String spMark) {
        String[] subRange = BillNoRng.split(spMark);
        if (subRange.length > 1) {
            return subRange[1];
        }
        return "0";
    }

    public static String getForMatBillNoRng(String BillNoRng) {
        if (StringUtils.isEmpty((String)BillNoRng)) {
            return "0";
        }
        return NoteHandlerHelper.formatLen(BillNoRng, 12);
    }

    public static void convertReturnSubBillRng(NoteReceivableInfo info, String subRng, String spMark) {
        String grdBag = info.getGrdBag();
        if (!"1".equals(grdBag) || StringUtils.isEmpty((String)subRng) || spMark.indexOf(spMark) < 0) {
            return;
        }
        info.setSubRange(subRng);
        info.setStartNo(NoteHandlerHelper.getStartNo(subRng, spMark));
        info.setEndNo(NoteHandlerHelper.getEndNo(subRng, spMark));
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)NoteHandlerHelper.getEncoding());
        }
        catch (Exception e) {
            logger.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)e);
            return "";
        }
    }

    public static String getEncoding() {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }
}

