/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.register;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.register.NotePacker;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.register.NoteParser;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;

public class RegisterNoteImpl
extends AbstractNotePayableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NEWEBDRAWTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968", (String)"RegisterNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        if (BankBusinessConfig.isOnlineRegister()) {
            return new NotePacker().packOnline(notePayableInfos);
        }
        return new NotePacker().packCommon(notePayableInfos);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String s) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        if (BankBusinessConfig.isOnlineRegister()) {
            new NoteParser().parseOnline(notePayableInfos, s);
        } else {
            new NoteParser().parseCommon(notePayableInfos, s);
        }
        return notePayableInfos;
    }
}

