/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.register;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.CIB_DC_Notepc_QueryPayPacker;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.fileupload.FileServerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.FileStorageUtil;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo payableInfo = (NotePayableInfo)notePayableInfos.get(0);
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(payableInfo.getDraftType())) {
            String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
            Element cms = CIB_DC_Packer.buildHeadMessage();
            Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
            Element QUERYDRAWFINANCETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"QUERYDRAWFINANCETRNRQ");
            JDomUtils.addChild((Element)QUERYDRAWFINANCETRNRQ, (String)"TRNUID", (String)TRNUID);
            Element body = JDomUtils.addChild((Element)QUERYDRAWFINANCETRNRQ, (String)"RQBODY");
            JDomUtils.addChild((Element)body, (String)"CLIENTREF", (String)payableInfo.getBankSerialNo());
            String encoding = RequestContextUtils.getCharset();
            String str = JDomUtils.root2String((Element)cms, (String)encoding);
            return str;
        }
        return CIB_DC_Notepc_QueryPayPacker.packQueryPay2(request.getNotePayableInfoList());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo payableInfo = (NotePayableInfo)notePayableInfos.get(0);
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(payableInfo.getDraftType())) {
            return this.parseOnline(request, responseStr);
        }
        HashMap<String, String> unknow = new HashMap<String, String>(){
            {
                this.put("3000", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25-\u8fbe\u5230\u670d\u52a1\u6700\u5927\u9650\u5236", (String)"QueryRegisterNotePayableImpl_18", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                this.put("4000", ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u9519\u8bef", (String)"QueryRegisterNotePayableImpl_19", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
        };
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("EBBATCHSTATUSTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
            return notePayableInfos;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        Element rs = (Element)list.get(0);
        String rsBillNo = rs.getChildText("BILLCODE");
        String BILLSTATUS = rs.getChildText("BILLSTATUS");
        String RSLTID = rs.getChildText("RSLTID");
        String RSLTMSG = rs.getChildText("RSLTMSG");
        ((NotePayableInfo)notePayableInfos.get(0)).setBillNo(rsBillNo);
        boolean stepsInOneFlag = false;
        if ("1".equals(payableInfo.getAutoAccept()) && "1".equals(payableInfo.getAutoReceive())) {
            stepsInOneFlag = true;
        }
        if ("000002".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("000002");
        } else if ("010004".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"QueryRegisterNotePayableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("010004");
        } else if ("020001".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"QueryRegisterNotePayableImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("020001");
        } else if ("020006".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)(stepsInOneFlag ? PaymentState.SUBMITED : PaymentState.SUCCESS), (String)BILLSTATUS, (String)String.format(ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536,\u4eba\u884c\u5904\u7406\u4fe1\u606f\uff1a%s", (String)"QueryRegisterNotePayableImpl_15", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), RSLTMSG));
            payableInfo.setNoteStatus("020006");
        } else if ("030001".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", (String)"QueryRegisterNotePayableImpl_6", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("030001");
        } else if ("030006".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", (String)"QueryRegisterNotePayableImpl_7", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("030006");
        } else if ("100001".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536", (String)"QueryRegisterNotePayableImpl_8", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("100001");
        } else if ("100006".equals(BILLSTATUS)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u80cc\u4e66\u5df2\u7b7e\u6536", (String)"QueryRegisterNotePayableImpl_9", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            payableInfo.setNoteStatus("100006");
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)BILLSTATUS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryRegisterNotePayableImpl_10", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        return notePayableInfos;
    }

    public List<NotePayableInfo> parseOnline(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo payableInfo = (NotePayableInfo)notePayableInfos.get(0);
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("QUERYDRAWFINANCETRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
        } else {
            Element body = EBBATCHSTATUSTRNRS.getChild("RSBODY");
            String resultCode = JDomUtils.getChildText((Element)body, (String)"RESULTCODE");
            if ("01".equals(resultCode)) {
                String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)errMessage);
            } else if ("02".equals(resultCode)) {
                String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)resultCode, (String)errMessage);
            } else if ("03".equals(resultCode)) {
                String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)resultCode, (String)errMessage);
            } else if ("04".equals(resultCode)) {
                try {
                    String fileName = JDomUtils.getChildText((Element)body, (String)"FILENAME");
                    String fileId = JDomUtils.getChildText((Element)body, (String)"FILEID");
                    String filePath = "";
                    this.logger.info("*******\u6587\u4ef6\u751f\u6210\u6210\u529f\uff0c\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
                    filePath = Common.downloadFileFromBank2(fileName, fileId).trim();
                    this.logger.info("*******\u4e0b\u8f7d\u6587\u4ef6\u5b8c\u6210:\u6587\u4ef6\u540d\uff1a" + fileName + ";\u6587\u4ef6id=" + fileId + ";\u6587\u4ef6\u8def\u5f84\uff1a" + filePath);
                    if (StringUtils.isEmpty((String)filePath)) {
                        this.logger.error("\u878d\u8d44\u7533\u8bf7\u5904\u7406\u7ed3\u679c\u67e5\u8be2\uff1a\u672a\u83b7\u53d6\u5230\u6587\u4ef6");
                        return notePayableInfos;
                    }
                    filePath = filePath.replace(".gz", "");
                    File file = new File(CleanPathUtil.cleanString((String)filePath));
                    String path = FileStorageUtil.getStorageRootPath();
                    for (int i = 0; i <= 20; ++i) {
                        this.logger.info("\u7b2c" + i + "\u6b21\u5bfb\u627e\u6587\u4ef6");
                        if (file.exists()) {
                            this.logger.info("*******\u8be5\u8def\u5f84\u4e0b\u6587\u4ef6\u5b58\u5728");
                            break;
                        }
                        this.logger.info("*******\u8be5\u8def\u5f84\u4e0b\u6587\u4ef6\u4e0d\u5b58\u5728");
                        File filePathDir = FileCommonUtils.getFileByPath((String)path);
                        File[] array = filePathDir.listFiles();
                        for (int j = 0; j < array.length; ++j) {
                            if (!array[j].isFile()) continue;
                            this.logger.info("\u8be5\u76ee\u5f55\u4e0b\u6587\u4ef6\uff1a{},\u6587\u4ef6\u540d\uff1a{}", new Object[]{j, array[j].getName()});
                        }
                        Thread.sleep(3000L);
                        file = new File(filePath);
                    }
                    this.logger.info("\u6587\u4ef6\u540d\u4fdd\u5b58\u5230\u5907\u7528\u5b57\u6bb5\u4e2d");
                    payableInfo.setReserved1(fileId);
                    if (!file.exists()) {
                        EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)resultCode, (String)ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u83b7\u53d6\u6210\u529f\uff0c\u6587\u4ef6\u4e0b\u8f7d\u672a\u5b8c\u6210\u3002", (String)"QueryRegisterNotePayableImpl_11", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                    } else {
                        this.logger.info("*******\u4e0a\u4f20\u6587\u4ef6\u81f3\u6587\u4ef6\u670d\u52a1\u5668");
                        String ServerPath = FileServerUtil.uploadFile((String)filePath, (String)fileName);
                        payableInfo.setReserved3(ServerPath);
                        payableInfo.setNoteStatus("000001");
                        EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)resultCode, (String)ResManager.loadKDString((String)"\u7535\u5b50\u5408\u540c\u751f\u6210\u6210\u529f\uff0c\u8bf7\u786e\u8ba4\u5408\u540c\u3002", (String)"QueryRegisterNotePayableImpl_12", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                        String md5 = Common.getMD5(new File(filePath));
                        this.logger.info("\u5bf9\u672c\u5730\u6587\u4ef6\u8fdb\u884c\u5220\u9664\uff0cMD5=" + md5);
                        payableInfo.setReserved4(md5);
                        file.delete();
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u878d\u8d44\u7533\u8bf7\u5904\u7406\u7ed3\u679c\u67e5\u8be2\u89e3\u6790\u62a5\u9519" + e);
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u878d\u8d44\u7533\u8bf7\u5904\u7406\u7ed3\u679c\u67e5\u8be2\u89e3\u6790\u62a5\u9519\u3002", (String)"QueryRegisterNotePayableImpl_13", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 100;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u540c\u6b65", (String)"QueryRegisterNotePayableImpl_14", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }
}

