/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.receivable.pledge;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = request.getAcnt();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBIMPAWNTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBIMPAWNTRNRQ");
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBIMPAWNTRNRQ_RQBODY = JDomUtils.addChild((Element)EBIMPAWNTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"APPDATE", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        Element RQBODY_ACCTFROM = JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"ACCTFROM");
        JDomUtils.addChild((Element)RQBODY_ACCTFROM, (String)"ACCTID", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"ISCIB", (String)"Y");
        Element RQBODY_ACCTTO = JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"ACCTTO");
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"ACCTID", (String)info.getPayeeAccNo());
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"NAME", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)RQBODY_ACCTTO, (String)"BANKNUM", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"MEMO", (String)"");
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            noteReceivableInfo.setRqstserialno(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLCODE", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"BILLAMT", (String)(noteReceivableInfo.getAmount() + ""));
            totalAmt = totalAmt.add(noteReceivableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBIMPAWNTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBIMPAWNTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBIMPAWNTRNRS = eb1.getChild("EBIMPAWNTRNRS");
        Element STATUS = EBIMPAWNTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return receivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

