/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.detail;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillQstockbillRequestV1;
import com.icbc.api.response.MybankEnterpriseBillQstockbillResponseV1;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.icbc.opa.service.note.detail.endorseInfo.EndorseRequestInfo;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import net.sf.json.JSONObject;

public class NoteHoldImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteHoldImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QSTOCKBILL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u4e00\u4ee3\u7968\u636e\u6301\u6709\u4fe1\u606f\u67e5\u8be2", (String)"NoteHoldImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        String subBizType = request.getHeader().getSubBizType();
        String URI = "mybank/enterprise/bill/qstockbill/V1";
        try {
            MybankEnterpriseBillQstockbillRequestV1.MybankEnterpriseBillQstockbillRequestBizV1 bizContent = new MybankEnterpriseBillQstockbillRequestV1.MybankEnterpriseBillQstockbillRequestBizV1();
            MybankEnterpriseBillQstockbillRequestV1 bankRequest = new MybankEnterpriseBillQstockbillRequestV1();
            bizContent.setTransCode("QSTOCKBILL");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            if (request.getBody().getPageNum() == 1) {
                bizContent.setNextTag("");
            } else {
                bizContent.setNextTag(request.getBody().getPageNum() - 1 + "");
            }
            bizContent.setHolderAcctId(request.getAcnt().getAccNo());
            bizContent.setDueDateBgn(LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(-6L)));
            bizContent.setDueDateEnd(LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(6L)));
            bizContent.setCdTp(request.getBody().getDraftType());
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            MybankEnterpriseBillQstockbillResponseV1 response = null;
            ArrayList<Detail> result = new ArrayList<Detail>(16);
            this.logger.info("\u5f85\u7b7e\u6536\u7968\u636e\u7533\u8bf7\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            response = (MybankEnterpriseBillQstockbillResponseV1)client.execute((IcbcRequest)bankRequest);
            this.logger.info("\u5f85\u7b7e\u6536\u7968\u636e\u7533\u8bf7\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            result.addAll(this.parseInfo(request, response));
            bizContent.setNextTag(this.getNextPageTag(response));
            EBBankDetailResponse responseBank = new EBBankDetailResponse(result);
            if (this.isLastPage(response)) {
                responseBank.setKeepFlag("1");
            } else {
                responseBank.setKeepFlag("0");
            }
            return responseBank;
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public List<Detail> parseInfo(BankNoteDetailRequest request, MybankEnterpriseBillQstockbillResponseV1 response) {
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6301\u7968\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef", (String)"NoteHoldImpl_5", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]));
        }
        List rds = response.getRd();
        ArrayList<Detail> result = new ArrayList<Detail>(rds.size());
        for (MybankEnterpriseBillQstockbillResponseV1.MybankEnterpriseBillQstockbillResponseRdV1 rd : rds) {
            Detail message = new Detail();
            try {
                EndorseRequestInfo info = new EndorseRequestInfo();
                info.setAccNo(request.getAcnt().getAccNo());
                info.setBillNo(rd.getPackNo());
                info.setStartNo(rd.getRangeBgn());
                info.setEndNo(rd.getRangeEnd());
                message = EndorseInfoImpl.getMessage(info);
                message.setIsNewECDS("0");
            }
            catch (Exception e) {
                message.setIsNoteSidesError("Y");
            }
            if ("CS06".equals(message.getNoteStatus()) || "CS05".equals(message.getNoteStatus())) continue;
            result.add(message);
        }
        return result;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(MybankEnterpriseBillQstockbillResponseV1 rspStr) {
        return rspStr.getNextTag();
    }

    public boolean isNeedPage() {
        return true;
    }

    public boolean isLastPage(MybankEnterpriseBillQstockbillResponseV1 rspStr) {
        return StringUtils.isEmpty((String)rspStr.getNextTag());
    }
}

