/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.receivable.payment;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseBillPsapplyRequestV1;
import com.icbc.api.response.MybankEnterpriseBillPsapplyResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.icbc.opa.service.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.icbc.opa.service.note.util.GetStore;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "PSAPPLY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        return null;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        return null;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String URI = "mybank/enterprise/bill/psapply/V1";
        String BASE_URL = GetStore.getBaseUrl();
        DefaultIcbcClient client = GetStore.getClient();
        List infos = request.getNoteReceivableInfos();
        try {
            MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestBizV1 bizContent = new MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestBizV1();
            MybankEnterpriseBillPsapplyRequestV1 bankRequest = new MybankEnterpriseBillPsapplyRequestV1();
            bizContent.setTransCode("PSAPPLY");
            String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
            boolean isProduct = StringUtils.isEmpty((String)signDate4Test);
            Date date = new Date();
            if (isProduct) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(request.getBankBatchSeqID());
            ArrayList<MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestRdV1> rds = new ArrayList<MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestRdV1>(16);
            for (NoteReceivableInfo info : infos) {
                MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestRdV1 rd = new MybankEnterpriseBillPsapplyRequestV1.MybankEnterpriseBillPsapplyRequestRdV1();
                rd.setHolderAcctNo(info.getDrawerAccNo());
                rd.setPackNo(info.getBillNo());
                rd.setRangeBgn(info.getStartNo());
                rd.setRangeEnd(info.getEndNo());
                rd.setRemark(info.getExplanation());
                rds.add(rd);
            }
            bizContent.setRd(rds);
            bankRequest.setServiceUrl(BASE_URL + URI);
            bankRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u63d0\u793a\u4ed8\u6b3e\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            try {
                MybankEnterpriseBillPsapplyResponseV1 response = (MybankEnterpriseBillPsapplyResponseV1)client.execute((IcbcRequest)bankRequest);
                this.logger.info("\u63d0\u793a\u4ed8\u6b3e\u94f6\u884c\u54cd\u5e94\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public EBBankNoteReceivableResponse parse(BankNoteReceivableRequest request, MybankEnterpriseBillPsapplyResponseV1 response) {
        List infos = request.getNoteReceivableInfos();
        if (!response.isSuccess()) {
            int code = response.getReturnCode();
            if (code < 0) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"EndorseNoteReceivableImpl_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            } else {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u5931\u8d25", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
            }
            return new EBBankNoteReceivableResponse(infos);
        }
        for (NoteReceivableInfo info : infos) {
            info.setBankRefKey(info.getBankBatchSeqId());
            info.setRspserialno(response.getBatSerialNo());
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u5931\u8d25", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        }
        return new EBBankNoteReceivableResponse(infos);
    }
}

