/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.codeless.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.note.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class EndorseImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseImpl.class);

    public List<NoteSidesInfo> parseNoteSides(String rspStr) {
        ArrayList<NoteSidesInfo> detailInfos = new ArrayList<NoteSidesInfo>(1);
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 , \u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s", (String)"EndorseImpl_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), statusCode, statusDesc));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalRows = PageResponse.getInteger("totalRows");
        int totalPages = PageResponse.getInteger("totalPages");
        if (totalRows == 0 || totalPages == 0) {
            return detailInfos;
        }
        JSONArray RangeEndoHistYqtOutBean = jsonBody.getJSONArray("rangeEndoHistYqtOutBeanList");
        for (int i = 0; i < RangeEndoHistYqtOutBean.size(); ++i) {
            JSONObject element = RangeEndoHistYqtOutBean.getJSONObject(i);
            NoteSidesInfo detailInfo = new NoteSidesInfo();
            String reqAcctName = element.getString("reqAcctName");
            detailInfo.setInitiatorName(reqAcctName);
            String reqAcctNo = element.getString("reqAcctNo");
            detailInfo.setInitiatorAcNo(reqAcctNo);
            String reqBankNo = element.getString("reqBankNo");
            detailInfo.setInitiatorBankCnaps(reqBankNo);
            String respAcctName = element.getString("respAcctName");
            detailInfo.setOpponentName(respAcctName);
            String respAcctNo = element.getString("respAcctNo");
            detailInfo.setOpponentAcNo(respAcctNo);
            String respBankNo = element.getString("respBankNo");
            detailInfo.setOpponentBankCnaps(respBankNo);
            String signMark = element.getString("signMark");
            detailInfo.setResv1(i + "");
            String reqRemark = element.getString("reqRemark");
            detailInfo.setRemark(reqRemark);
            String endoDate = element.getString("endoDate");
            detailInfo.setSignDate(endoDate);
            String endoType = element.getString("endoType");
            if (!"ET05".equals(endoType) || !"SU00".equals(signMark)) continue;
            detailInfo.setSubType("10");
            detailInfos.add(detailInfo);
        }
        return detailInfos;
    }

    public List<NoteSidesInfo> getMessage(String accno, String billNo, String startNo, String endNo) {
        String rspStr = "";
        ArrayList<NoteSidesInfo> list = new ArrayList<NoteSidesInfo>(16);
        try {
            int pageTag = 1;
            SdkInit.init();
            do {
                ApiHeader header = new ApiHeader();
                header.setMsgtype("nbts_queryRangeEndoHistYqt");
                header.setTraceno(Sequence.genSequence());
                String token = FetchTokenUtils.getToken();
                header.setToken(token);
                HashMap<String, Object> body = new HashMap<String, Object>(1);
                body.put("certifyAcctNo", accno);
                body.put("billNo", billNo);
                body.put("rangeStart", startNo);
                body.put("rangeEnd", endNo);
                HashMap<String, Integer> PageRequest = new HashMap<String, Integer>(1);
                PageRequest.put("pageSize", 100);
                PageRequest.put("currentPage", pageTag);
                body.put("PageRequest", PageRequest);
                body.put("eleSign", Sequence.gen16Sequence());
                logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(body));
                ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
                rspStr = JSON.toJSONString((Object)data);
                logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
                if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                    SdkInit.checkToken(token);
                }
                List<NoteSidesInfo> details = this.parseNoteSides(rspStr);
                list.addAll(details);
            } while (!this.isLastPage(pageTag = this.getNextPageTag(rspStr, pageTag)));
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"EndorseImpl_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return list;
    }

    public int getNextPageTag(String rspStr, int pageTag) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalPages = PageResponse.getInteger("totalPages");
        if (pageTag < totalPages) {
            return pageTag + 1;
        }
        return 0;
    }

    public boolean isLastPage(int pageTag) {
        return pageTag == 0;
    }
}

