/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.receivable.discount;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BIDISC";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        String TransCode = "BIDISC";
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, infos[0].getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)infos[0].getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)infos[0].getRegisterNmae());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)infos[0].getRegisterAcno());
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)infos[0].getDrawerAccNo());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)infos[0].getAmount()));
        boolean isSameBank = false;
        if (infos[0].getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)infos[0].getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if (!isSameBank) {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"0");
            JDomUtils.addChild((Element)in, (String)"RecBankName", (String)infos[0].getPayeeBankName());
            JDomUtils.addChild((Element)in, (String)"RecCityName", (String)infos[0].getPayeeCity());
            JDomUtils.addChild((Element)in, (String)"RecBankNo", (String)infos[0].getPayeeBankCnaps());
        } else {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"1");
            JDomUtils.addChild((Element)in, (String)"RecBankName", (String)infos[0].getPayeeBankName());
            JDomUtils.addChild((Element)in, (String)"RecCityName", (String)infos[0].getPayeeCity());
            String bankno = infos[0].getPayeeBankCnaps();
            if (StringUtils.isEmpty((String)bankno)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u884c\u53f7\u4e3a\u7a7a", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
            }
            int length = bankno.length();
            bankno = bankno.substring(length - 8, length);
            JDomUtils.addChild((Element)in, (String)"RecBankNo", (String)bankno);
        }
        JDomUtils.addChild((Element)in, (String)"TranType", (String)infos[0].getOperationCode());
        JDomUtils.addChild((Element)in, (String)"OnlineFlag", (String)("0".equals(infos[0].getAutoAccept()) ? "SM00" : "SM01"));
        JDomUtils.addChild((Element)in, (String)"BanFlag", (String)infos[0].getTransferFlag());
        JDomUtils.addChild((Element)in, (String)"TranRate", (String)DiscountNoteReceivableImpl.getDouble(infos[0].getDisCountRate()));
        JDomUtils.addChild((Element)in, (String)"RedeemOpenDate", (String)"");
        JDomUtils.addChild((Element)in, (String)"RedeemEndDate", (String)"");
        JDomUtils.addChild((Element)in, (String)"RedeemRate", (String)"");
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        infos[0].getPayeeAccNo();
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, TransCode);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        ICBC_CMP_NoteParser.parsePay(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }

    public static String getDouble(String str) {
        Double num;
        if (StringUtils.isEmpty((String)str)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u7387\u4e3a\u7a7a", (String)"DiscountNoteReceivableImpl_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        str = str + "%";
        NumberFormat nf = NumberFormat.getPercentInstance();
        try {
            Number m = nf.parse(str);
            DecimalFormat myformat = new DecimalFormat("#0.000000");
            num = Double.parseDouble(m.toString());
            num = Double.parseDouble(myformat.format(num));
            System.out.println(num);
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5c0f\u6570\u8f6c\u6362\u9519\u8bef", (String)"DiscountNoteReceivableImpl_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        return num.toString();
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        NoteReceivableInfo info = (NoteReceivableInfo)request.getNoteReceivableInfos().get(0);
        if (info.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.receivable.discount.DiscountNoteReceivableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.receivable.discount.DiscountNoteReceivableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

