/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.codeless.payable.register;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.codeless.CommonParser;
import kd.ebg.note.banks.ccb.dc.services.codeless.payable.register.CodelessQueryBusinessImpl;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CodelessBusinessRegisterImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return CodelessQueryBusinessImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WH201";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest request, String s) {
        List infos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)infos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH201", ((NotePayableInfo)infos.get(0)).getBankBatchSeqId());
        Element tx_info = JDomUtils.addChild((Element)header, (String)"TX_INFO");
        LocalDate issueDate = info.getBookingDate();
        if (issueDate == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u51fa\u7968\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CodelessRegisterImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        LocalDate dueDate = info.getDueDate();
        if (dueDate == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CodelessRegisterImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)tx_info, (String)"IssuOfPpr_Dt", (String)issueDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)tx_info, (String)"Bill_ExDat", (String)dueDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)tx_info, (String)"BlGrdBagCrcl_Prmt_Ind", (String)info.getGrdBag());
        JDomUtils.addChild((Element)tx_info, (String)"EBillFrbdTrsferMarkCd", (String)info.getTransferFlag());
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Rmtr_AccNm", (String)info.getDrawerAccName());
        JDomUtils.addChild((Element)tx_info, (String)"Rmtr_AcNoInf", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)tx_info, (String)"Rmtr_DepBnk_BrNo", (String)info.getDrawerBankCnaps());
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Prtc_SgnSl_MtdCd", (String)"PS01");
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Prtc_Elc_Sgn", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Acptr_Id_TpCd", (String)"DT02");
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Acptr_AccNm", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)tx_info, (String)"Acptr_AcNoInf", (String)info.getAcceptorAccNo());
        JDomUtils.addChild((Element)tx_info, (String)"Acptr_DepBnk_BrNo", (String)info.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)tx_info, (String)"Bl_RcvPymtPs_Id_TpCd", (String)"DT02");
        JDomUtils.addChild((Element)tx_info, (String)"Bl_RcvPymtPs_AccNm", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)tx_info, (String)"RcvPymtPs_AccNo", (String)info.getPayeeAccNo());
        JDomUtils.addChild((Element)tx_info, (String)"RPPDBnk_BrNo", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)tx_info, (String)"Bl_Aply_Amt", (String)info.getAmount().toPlainString());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        CommonParser.parsePayable(request.getNotePayableInfoList(), responseStr);
        return request.getNotePayableInfoList();
    }
}

