/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.detail.holdinfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteInfoParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteInfoParser.class);

    public Detail parserNoteInfoResponse(String rspStr, Detail info) throws ParseException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>();
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            Element detaillist = JDomUtils.getChildElement((Element)txBody, (String)"DETAILLIST");
            List detailLists = detaillist.getChildren("DETAILINFO");
            for (Element detail : detailLists) {
                String infos = JDomUtils.getChildText((Element)detail, (String)"BkDetail7");
                String BkAcctNo1 = JDomUtils.getChildText((Element)detail, (String)"BkAcctNo1");
                info.setDrawerAccNo(BkAcctNo1);
                String BkBrchNo1 = JDomUtils.getChildText((Element)detail, (String)"BkBrchNo1");
                info.setDrawerCnapsCode(BkBrchNo1);
                String Bk60Name1 = JDomUtils.getChildText((Element)detail, (String)"Bk60Name1");
                info.setDrawerAccName(Bk60Name1);
                String BkFlag1 = JDomUtils.getChildText((Element)detail, (String)"BkFlag1");
                info.setNoteStatus(BkFlag1);
                String BkFlag2 = JDomUtils.getChildText((Element)detail, (String)"BkFlag2");
                info.setTransferFlag(BkFlag2);
                String BkAcctNo5 = JDomUtils.getChildText((Element)detail, (String)"BkAcctNo5");
                info.setAcceptorAccNo(BkAcctNo5);
                String BkAcctNo2 = JDomUtils.getChildText((Element)detail, (String)"BkAcctNo2");
                info.setPayeeAccNo(BkAcctNo2);
                String Bk60Name2 = JDomUtils.getChildText((Element)detail, (String)"Bk60Name2");
                info.setPayeeAccName(Bk60Name2);
                String BkBrchNo3 = JDomUtils.getChildText((Element)detail, (String)"BkBrchNo3");
                info.setPayeeCnapsCode(BkBrchNo3);
                String[] endorseinfo = infos.split("\\|\\@\\|\\$");
                for (int i = 0; i < endorseinfo.length; ++i) {
                    String signdate;
                    NoteSidesInfo infoDetail;
                    String eachinfo = endorseinfo[i];
                    String[] endorse = eachinfo.split("\\|");
                    String type = endorse[0];
                    if ("00".equals(type)) {
                        infoDetail = new NoteSidesInfo();
                        infoDetail.setInitiatorName(endorse[1]);
                        infoDetail.setOpponentName(endorse[2]);
                        signdate = endorse[4];
                        infoDetail.setSignDate(signdate);
                        infoDetail.setTransferFlag(endorse[3]);
                        infoDetail.setBusinessCode("10");
                        infoDetail.setResv1(endorseinfo.length - i + "");
                        if (endorse.length == 6) {
                            infoDetail.setRemark(endorse[5]);
                        }
                        result.add(infoDetail);
                        continue;
                    }
                    if (!"02".equals(type)) continue;
                    infoDetail = new NoteSidesInfo();
                    infoDetail.setInitiatorName(endorse[1]);
                    infoDetail.setOpponentName(endorse[2]);
                    signdate = endorse[3];
                    infoDetail.setSignDate(signdate);
                    infoDetail.setTransferFlag(endorse[3]);
                    infoDetail.setBusinessCode("18");
                    infoDetail.setResv1(endorseinfo.length - i + "");
                    if (endorse.length == 6) {
                        infoDetail.setRemark(endorse[5]);
                    }
                    result.add(infoDetail);
                }
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)("hold query error:" + response.getResponseMessage()));
        }
        info.setNoteSidesInfo(result);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return info;
    }
}

