/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.receive;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryReceiveNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public static final int PAGE_SIZE = 200;
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceiveNotePayableImpl.class);

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH026", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)info.getDraftType());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date3", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date4", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt2", (String)"");
        if (((NotePayableInfo)notePayableInfos.get(0)).getBankBatchCount() == 1) {
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        }
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)"0002");
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000") && !response.getResponseCode().equals("YBLECDA66261")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            Element detaillist = txBody.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            for (NotePayableInfo info : notePayableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        this.logger.info("\u7968\u53f7\uff1a" + info.getBillNo() + "----BkFlag2:" + BkFlag2 + "----BkFlag1:" + BkFlag1);
                        if (BkFlag2.equals("00") || "030006".equals(BkFlag1)) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QueryReceiveNotePayableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            info.setNoteStatus("030006");
                            continue;
                        }
                        if (BkFlag2.equals("04")) {
                            info.setNoteStatus("030001");
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u5f85\u7b7e\u6536", (String)"QueryReceiveNotePayableImpl_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                            continue;
                        }
                        if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        if (BkFlag2.equals("07")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QueryReceiveNotePayableImpl_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        if (BkFlag2.equals("02")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryReceiveNotePayableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u793a\u6536\u7968\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryReceiveNotePayableImpl_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                        continue;
                    }
                    this.logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        return flag;
    }
}

