/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.receive;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.payable.receive.QueryReceiveNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ReceiveNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiveNotePayableImpl.class);
    private static final String SEPERATOR = "|";

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryReceiveNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        if (notePayableInfos.size() > 1) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u51fa\u7968\u4eba\u5907\u6ce8|\u8ba2\u5355\u53f7|", (String)"ReceiveNotePayableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < notePayableInfos.size(); ++i) {
                NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(i);
                sBuffer.append(info.getBillNo()).append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH055Payable(fileContent, notePayableInfos, "0001");
        }
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH004", info.getBankBatchSeqId());
        Element txbody = NoteCommonPacker.createTransactionBody(header, "", info.getBankBatchSeqId());
        JDomUtils.addChild((Element)txbody, (String)"BkListNo1", (String)info.getBillNo());
        JDomUtils.addChild((Element)txbody, (String)"BkDetail1", (String)info.getExplanation());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        NoteCommonParser.parsePayable(request.getNotePayableInfoList(), responseStr);
        return request.getNotePayableInfoList();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968", (String)"ReceiveNotePayableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

