/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.payable.register.FileUtil.CCB_DCFileUtil;
import kd.ebg.note.banks.ccb.dc.services.note.payable.register.FileUtil.UploadFileImpl;
import kd.ebg.note.banks.ccb.dc.services.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);
    private static final String SEPERATOR = "|";

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "6WH002,6WH002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\uff0c30\u7b14\u4ee5\u51856WH002\uff0c30\u4ee5\u4e0a\uff0c200\u7b14\u4ee5\u51856WH002", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        if (notePayableInfos.size() > 30) {
            CCB_DCFileUtil fileUtil = new CCB_DCFileUtil();
            String datestr = DateUtil.formatDate((Date)new Date());
            String custid = RequestContextUtils.getBankParameterValue((String)"CUST_ID");
            String fileName = "05" + datestr + "4" + custid + ".txt";
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccbRegister"));
            sBuffer.append("\r\n");
            for (int i = 0; i < notePayableInfos.size(); ++i) {
                NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(i);
                sBuffer.append(info.getBillNo()).append(SEPERATOR);
                sBuffer.append(info.getContractNo()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR);
                sBuffer.append(info.getTransferFlag()).append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            Map<String, String> map = fileUtil.uploadFileMD5(fileName, fileContent);
            if (map == null) {
                this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6279\u91cf\u51fa\u7968\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
            String absoluteFileName = map.get("fileName");
            String MD5 = map.get("MD5");
            this.logger.info("fileName\uff1a" + fileName);
            this.logger.info("MD5\uff1a" + MD5);
            if (StringUtils.isEmpty((String)absoluteFileName) || StringUtils.isEmpty((String)MD5)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u3002", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
            UploadFileImpl filename = new UploadFileImpl();
            String finalName = filename.getinfo(absoluteFileName);
            this.logger.info("finalName\uff1a" + finalName);
            if (StringUtils.isEmpty((String)fileName)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u8c03\u7528\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"RegisterNotePayableImpl_4", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
            Element header = CCB_DC_Packer.createTransactionHeader("6WH020", ((NotePayableInfo)notePayableInfos.get(0)).getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", ((NotePayableInfo)notePayableInfos.get(0)).getBatchSeqId());
            JDomUtils.addChild((Element)txBody, (String)"BkNum1", (String)(notePayableInfos.size() + ""));
            JDomUtils.addChild((Element)txBody, (String)"BkType1", (String)"0001");
            JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)"AC01");
            JDomUtils.addChild((Element)txBody, (String)"BkDetail1", (String)MD5);
            JDomUtils.addChild((Element)txBody, (String)"BkListNo2", (String)((NotePayableInfo)notePayableInfos.get(0)).getContractNo());
            JDomUtils.addChild((Element)txBody, (String)"BkLevel1");
            JDomUtils.addChild((Element)txBody, (String)"Bk60Name2");
            JDomUtils.addChild((Element)txBody, (String)"Bk8Date3");
            JDomUtils.addChild((Element)txBody, (String)"SEND_FILE", (String)finalName);
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        String DraftType = ((NotePayableInfo)notePayableInfos.get(0)).getDraftType();
        if ("AC01".equals(DraftType)) {
            Element header = CCB_DC_Packer.createTransactionHeader("6WH002", ((NotePayableInfo)notePayableInfos.get(0)).getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)((NotePayableInfo)notePayableInfos.get(0)).getContractNo());
            JDomUtils.addChild((Element)txBody, (String)"BkLevel1");
            JDomUtils.addChild((Element)txBody, (String)"Bk60Name2");
            JDomUtils.addChild((Element)txBody, (String)"Bk8Date3");
            JDomUtils.addChild((Element)txBody, (String)"BkNum1", (String)String.valueOf(notePayableInfos.size()));
            Element DETAILLIST = JDomUtils.addChild((Element)txBody, (String)"DETAILLIST");
            for (int i = 0; i < notePayableInfos.size(); ++i) {
                Element DETAILINFO = JDomUtils.addChild((Element)DETAILLIST, (String)"DETAILINFO");
                NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(i);
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkListNo2", (String)info.getBillNo());
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkListNo3", (String)info.getContractNo());
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkListNo4");
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkEcdBatchNo", (String)info.getBankDetailSeqId());
                JDomUtils.addChild((Element)DETAILINFO, (String)"Bk8Date1", (String)info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)DETAILINFO, (String)"Bk8Date2", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkDetail2", (String)(info.getExplanation() + info.getBankDetailSeqId()));
                JDomUtils.addChild((Element)DETAILINFO, (String)"BkType1", (String)info.getTransferFlag());
            }
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        if ("AC02".equals(DraftType)) {
            return this.pack(notePayableInfos);
        }
        return null;
    }

    public String pack(List<NotePayableInfo> notePayableInfos) {
        Element header = CCB_DC_Packer.createTransactionHeader("6WH003", notePayableInfos.get(0).getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", notePayableInfos.get(0).getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)notePayableInfos.get(0).getAmount().toString());
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date1", (String)DateUtil.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date2", (String)notePayableInfos.get(0).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)notePayableInfos.get(0).getTransferFlag());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)notePayableInfos.get(0).getDrawerAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)notePayableInfos.get(0).getDrawerAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)notePayableInfos.get(0).getDrawerBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkLevel1");
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name2");
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date3");
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1");
        JDomUtils.addChild((Element)txBody, (String)"BkDetail2");
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name3", (String)notePayableInfos.get(0).getAcceptorAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo3", (String)notePayableInfos.get(0).getAcceptorAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo3", (String)notePayableInfos.get(0).getAcceptorBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name4", (String)notePayableInfos.get(0).getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo4", (String)notePayableInfos.get(0).getPayeeAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo4", (String)notePayableInfos.get(0).getPayeeBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkDetail3", (String)notePayableInfos.get(0).getExplanation());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        NoteCommonParser.parsePayable(request.getNotePayableInfoList(), responseStr);
        return request.getNotePayableInfoList();
    }
}

