/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel.CancelTypeUtil;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel.queryinfo.QueryCancelInfoImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo info2;
        List noteReceivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info2 : noteReceivableInfos) {
            info2.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info2.getPayeeAccNo(), info2.getPayeeBankName()));
        }
        BankAcnt acnt = request.getAcnt();
        info2 = (NoteReceivableInfo)noteReceivableInfos.get(0);
        LocalDate nowLocalDate = info2.getDueDate();
        Date date = Date.from(nowLocalDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        if ("20".equals(info2.getOperationCode()) && !DateTimeUtils.dayBefore((Date)date, (Date)new Date())) {
            Element root = CCB_DC_Packer.createTransactionHeader("6WH016", info2.getBankBatchSeqId());
            JDomUtils.addChild((Element)root, (String)"SIGN_INFO", (String)"");
            Element tx = JDomUtils.addChild((Element)root, (String)"TX_INFO");
            JDomUtils.addChild((Element)tx, (String)"BkType1", (String)"0001");
            JDomUtils.addChild((Element)tx, (String)"BkListNo1", (String)info2.getBillNo());
            return NoteCommonPacker.root2StringSafeMod(root);
        }
        QueryCancelInfoImpl impl = new QueryCancelInfoImpl();
        Map<String, String> map = impl.getinfo(noteReceivableInfos);
        Element root = CCB_DC_Packer.createTransactionHeader("6WH015", info2.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", info2.getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info2.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"BkType1", (String)CancelTypeUtil.INSTANCE.convert2Bank(info2.getOperationCode()));
        JDomUtils.addChild((Element)txBody, (String)"BkRole", (String)"RC01");
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)acnt.getAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo2", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkOldPlatDate", (String)map.get("BkOldPlatDate"));
        JDomUtils.addChild((Element)txBody, (String)"BkOldSeq", (String)map.get("BkOldSeq"));
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkDetail2", (String)info2.getExplanation());
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        NoteCommonParser.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

