/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.discount;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final String SEPERATOR = "|";
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(DiscountNoteReceivableImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo info2;
        List receivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info2 : receivableInfos) {
            info2.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info2.getPayeeAccNo(), info2.getPayeeBankName()));
        }
        BankAcnt acnt = request.getAcnt();
        if (receivableInfos.size() > 1) {
            String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u7968\u636e\u91d1\u989d|\u51fa\u7968\u65e5|\u5230\u671f\u65e5|\u8d34\u73b0\u65e5\u671f|\u8d34\u73b0\u79cd\u7c7b|\u8d34\u73b0\u5229\u7387|\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d|\u8d34\u73b0\u4e0d\u5f97\u8f6c\u8ba9\u6807\u8bb0|\u8d34\u73b0\u4ea4\u6613\u5408\u540c\u7f16\u53f7|\u8d34\u73b0\u53d1\u7968\u53f7\u7801|\u8d34\u51fa\u4eba\u5907\u6ce8|\u6279\u6b21\u53f7|\u5165\u8d26\u8d26\u53f7|\u5165\u8d26\u5f00\u6237\u884c|\u5165\u8d26\u5f00\u6237\u884c\u540d\u79f0|\u8d34\u73b0\u7533\u8bf7\u4eba\u540d\u79f0|\u8d34\u73b0\u7533\u8bf7\u4eba\u8d26\u53f7|\u8d34\u73b0\u7533\u8bf7\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u8d34\u73b0\u7533\u8bf7\u4eba\u5f00\u6237\u884c\u540d\u79f0|\u8d34\u5165\u4eba\u540d\u79f0|\u8d34\u5165\u4eba\u8d26\u53f7|\u8d34\u5165\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u8d34\u5165\u4eba\u5f00\u6237\u884c\u540d\u79f0|\u4ed8\u606f\u65b9\u5f0f|\u4ed8\u606f\u4eba\u540d\u79f0|\u4ed8\u606f\u4eba\u8d26\u53f7|\u4ed8\u606f\u6bd4\u4f8b|\u5907\u6ce82|\u6e05\u7b97\u65b9\u5f0f|", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < receivableInfos.size(); ++i) {
                NoteReceivableInfo info3 = (NoteReceivableInfo)receivableInfos.get(i);
                sBuffer.append(info3.getBillNo()).append(SEPERATOR);
                sBuffer.append(info3.getDisCountAmount()).append(SEPERATOR);
                sBuffer.append(info3.getIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info3.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                if (StringUtils.isEmpty((String)signDate4Test)) {
                    sBuffer.append(DateUtil.formatDate((Date)new Date())).append(SEPERATOR);
                } else {
                    sBuffer.append(signDate4Test).append(SEPERATOR);
                }
                sBuffer.append("RM00").append(SEPERATOR);
                Double rate = Double.parseDouble(info3.getDisCountRate()) / 100.0;
                sBuffer.append(rate.toString()).append(SEPERATOR);
                sBuffer.append(info3.getAmount().toString()).append(SEPERATOR);
                sBuffer.append(info3.getTransferFlag()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getExplanation()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getAcceptorAccNo()).append(SEPERATOR);
                sBuffer.append(info3.getAcceptorBankCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(acnt.getAccName()).append(SEPERATOR);
                sBuffer.append(acnt.getAccNo()).append(SEPERATOR);
                sBuffer.append(acnt.getCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getPayeeAccName()).append(SEPERATOR);
                sBuffer.append(info3.getPayeeAccNo()).append(SEPERATOR);
                sBuffer.append(info3.getPayeeBankCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                if (StringUtils.isEmpty((String)info3.getDiscountType())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u4fe1\u606f\u83b7\u53d6\u5931\u8d25", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                }
                if ("2".equals(info3.getDiscountType())) {
                    sBuffer.append("2").append(SEPERATOR);
                    sBuffer.append(info3.getDiscountAccNo()).append(SEPERATOR);
                    sBuffer.append(info3.getDiscountAccName()).append(SEPERATOR);
                } else if ("1".equals(info3.getDiscountType())) {
                    sBuffer.append("1").append(SEPERATOR);
                    sBuffer.append("").append(SEPERATOR);
                    sBuffer.append("").append(SEPERATOR);
                } else {
                    sBuffer.append("3").append(SEPERATOR);
                    sBuffer.append(info3.getDiscountAccNo()).append(SEPERATOR);
                    sBuffer.append(info3.getDiscountAccName()).append(SEPERATOR);
                }
                sBuffer.append(info3.getDisCountRate()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("SM00").append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH020(fileContent, receivableInfos, "0003");
        }
        info2 = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Packer.createTransactionHeader("6WH008", info2.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", info2.getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkNum1", (String)"1");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt9", (String)info2.getDisCountAmount());
        Element detaillist = JDomUtils.addChild((Element)txBody, (String)"DETAILLIST");
        Element detailinfo = JDomUtils.addChild((Element)txBody, (String)"DETAILINFO");
        JDomUtils.addChild((Element)detailinfo, (String)"BkListNo1", (String)info2.getBillNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BKEcdsType", (String)info2.getDraftType());
        JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name1", (String)acnt.getAccName());
        JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)detailinfo, (String)"BkRate1", (String)info2.getDisCountRate());
        if ("RM01".equals(info2.getOperationCode())) {
            JDomUtils.addChild((Element)detailinfo, (String)"BkRate2", (String)info2.getRateType());
            JDomUtils.addChild((Element)detailinfo, (String)"Bk8Date2", (String)info2.getRedemptionSDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)detailinfo, (String)"Bk8Date3", (String)info2.getRedemptionEDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)detailinfo, (String)"BkAmt3", (String)info2.getAmount().toString());
        }
        JDomUtils.addChild((Element)detailinfo, (String)"BkType1", (String)"RM00");
        JDomUtils.addChild((Element)detailinfo, (String)"BkAmt2", (String)info2.getAmount().toString());
        JDomUtils.addChild((Element)detailinfo, (String)"BkListNo2", (String)info2.getContractNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BkListNo3", (String)"");
        JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name3", (String)info2.getPayeeAccName());
        JDomUtils.addChild((Element)detailinfo, (String)"BkBrchNo3", (String)info2.getPayeeBankCnaps());
        JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo4", (String)info2.getAcceptorAccNo());
        JDomUtils.addChild((Element)detailinfo, (String)"BkBrchNo4", (String)info2.getAcceptorBankCnaps());
        if (StringUtils.isEmpty((String)info2.getDiscountType())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u4fe1\u606f\u83b7\u53d6\u5931\u8d25", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)detailinfo, (String)"BkRate", (String)info2.getIncreaseRate());
        if ("2".equals(info2.getDiscountType())) {
            JDomUtils.addChild((Element)detailinfo, (String)"BkFlag3", (String)"2");
            JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name4", (String)info2.getDiscountAccName());
            JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo5", (String)info2.getDiscountAccNo());
        } else if ("3".equals(info2.getDiscountType())) {
            JDomUtils.addChild((Element)detailinfo, (String)"BkFlag3", (String)"3");
            JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name4", (String)info2.getDiscountAccName());
            JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo5", (String)info2.getDiscountAccNo());
        } else {
            JDomUtils.addChild((Element)detailinfo, (String)"BkFlag3", (String)"1");
            JDomUtils.addChild((Element)detailinfo, (String)"Bk60Name4", (String)"");
            JDomUtils.addChild((Element)detailinfo, (String)"BkAcctNo5", (String)"");
        }
        JDomUtils.addChild((Element)detailinfo, (String)"BkEcdBatchNo", (String)"");
        JDomUtils.addChild((Element)detailinfo, (String)"BkDetail1", (String)"");
        JDomUtils.addChild((Element)detailinfo, (String)"BkDetail2", (String)info2.getExplanation());
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        NoteCommonParser.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0", (String)"DiscountNoteReceivableImpl_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

