/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.discount;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.QueryNoteStatusPacker;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.discount.DiscountNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryDiscountNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(DiscountNoteReceivableImpl.class);
    public static final int PAGE_SIZE = 200;

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        if (info.getBankBatchCount() > 1) {
            Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
            JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
            JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        return QueryNoteStatusPacker.packQueryPay(noteReceivableInfos, "0005");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000") && !response.getResponseCode().equals("YBLECDA66261")) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            Element detaillist = txBody.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            for (NoteReceivableInfo info : noteReceivableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                        String BKRevAmount = JDomUtils.getChildTextTrim((Element)list, (String)"BKRevAmount");
                        String BkRate1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkRate1");
                        if (BkFlag2.equals("00") || BkFlag2.equals("06") || BkFlag1.equals("000000")) {
                            info.setDisCountRate(BkRate1);
                            if (!StringUtils.isEmpty((String)BKRevAmount)) {
                                info.setAmount(new BigDecimal(BKRevAmount));
                            }
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryDiscountNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        if (BkFlag2.equals("02")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u94f6\u884c\u5df2\u63a5\u6536\u3002", (String)"QueryDiscountNoteReceivableImpl_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                            continue;
                        }
                        if (BkFlag2.equals("04")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u5f85\u7b7e\u6536", (String)"QueryDiscountNoteReceivableImpl_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                            continue;
                        }
                        if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            continue;
                        }
                        if (BkFlag2.equals("07")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QueryDiscountNoteReceivableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                        continue;
                    }
                    this.logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
        return noteReceivableInfos;
    }

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u7ed3\u679c\u540c\u6b65", (String)"QueryDiscountNoteReceivableImpl_4", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        if (((NoteReceivableInfo)noteReceivableInfos.get(0)).getBankBatchCount() > 1) {
            return super.doBizWithPage(request);
        }
        return super.doBizNoPage(request);
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5206\u9875" + flag);
        return flag;
    }
}

