/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.endorse;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.BatchUtil;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final String SEPERATOR = "|";
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo info2;
        List receivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info2 : receivableInfos) {
            info2.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info2.getPayeeAccNo(), info2.getPayeeBankName()));
        }
        BankAcnt acnt = request.getAcnt();
        if (receivableInfos.size() > 1) {
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u7968\u636e\u91d1\u989d|\u51fa\u7968\u65e5|\u5230\u671f\u65e5|\u80cc\u4e66\u4e0d\u5f97\u8f6c\u8ba9\u6807\u8bb0|\u80cc\u4e66\u4eba\u540d\u79f0|\u80cc\u4e66\u4eba\u8d26\u53f7|\u80cc\u4e66\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u80cc\u4e66\u4eba\u5f00\u6237\u884c\u540d\u79f0|\u88ab\u80cc\u4e66\u4eba\u540d\u79f0|\u88ab\u80cc\u4e66\u4eba\u8d26\u53f7|\u88ab\u80cc\u4e66\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u88ab\u80cc\u4e66\u4eba\u5f00\u6237\u884c\u540d\u79f0|\u80cc\u4e66\u4eba\u5907\u6ce8|\u5907\u6ce82||", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (int i = 0; i < receivableInfos.size(); ++i) {
                NoteReceivableInfo info3 = (NoteReceivableInfo)receivableInfos.get(i);
                sBuffer.append(info3.getBillNo()).append(SEPERATOR);
                sBuffer.append(info3.getAmount()).append(SEPERATOR);
                sBuffer.append(info3.getIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info3.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info3.getTransferFlag()).append(SEPERATOR);
                sBuffer.append(acnt.getAccName()).append(SEPERATOR);
                sBuffer.append(acnt.getAccNo()).append(SEPERATOR);
                sBuffer.append(acnt.getCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getPayeeAccName()).append(SEPERATOR);
                sBuffer.append(info3.getPayeeAccNo()).append(SEPERATOR);
                sBuffer.append(info3.getPayeeBankCnaps()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info3.getExplanation()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR).append(SEPERATOR);
                sBuffer.append("\r\n");
            }
            String fileContent = sBuffer.toString();
            return BatchUtil.uploadFile6WH020(fileContent, receivableInfos, "0002");
        }
        info2 = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Packer.createTransactionHeader("6WH006", info2.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", info2.getBankBatchSeqId());
        String localDate = LocalDateUtil.formatDate((LocalDate)LocalDate.now());
        info2.setReserved1(localDate);
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info2.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"BkType1", (String)info2.getTransferFlag());
        JDomUtils.addChild((Element)txBody, (String)"BkRole", (String)"RC01");
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)acnt.getAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name3", (String)info2.getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo3", (String)info2.getPayeeAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo3", (String)info2.getPayeeBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkDetail2", (String)info2.getExplanation());
        JDomUtils.addChild((Element)txBody, (String)"SIGN_INFO", (String)info2.getBankBatchSeqId());
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        NoteCommonParser.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u80cc\u4e66", (String)"EndorseNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

