/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.util.List;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CommNotePacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CommNotePacker.class);

    public static Element packNoteHeader(Element root, String msgType) {
        Element hermes = JDomUtils.addChild((Element)root, (String)"Hermes");
        Element head = JDomUtils.addChild((Element)hermes, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"MsgTyp", (String)msgType);
        return hermes;
    }

    public static Element packHermes(Element root, String Channel2, String MsgType, String PtcptSgntr) {
        Element hermes = JDomUtils.addChild((Element)root, (String)"Hermes");
        JDomUtils.addChild((Element)hermes, (String)"Channel", (String)Channel2);
        JDomUtils.addChild((Element)hermes, (String)"MsgType", (String)MsgType);
        Element SgntrMk = JDomUtils.addChild((Element)hermes, (String)"SgntrMk");
        JDomUtils.addChild((Element)SgntrMk, (String)"PrxySgntr", (String)"PS01");
        JDomUtils.addChild((Element)SgntrMk, (String)"PtcptSgntr", (String)"12345678");
        return hermes;
    }

    public static Element packHermes(Element root, String Channel2, String MsgType) {
        Element hermes = JDomUtils.addChild((Element)root, (String)"Hermes");
        JDomUtils.addChild((Element)hermes, (String)"Channel", (String)Channel2);
        JDomUtils.addChild((Element)hermes, (String)"MsgType", (String)MsgType);
        return hermes;
    }

    public static void parserNoteReq(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        infos.get(0).setBankRefKey("");
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001ResponseCode\uff1a" + rsp.getResponseCode());
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001\uff1a\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"0000".equals(rsp.getResponseCode())) {
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001ResponseCode\uff1a" + rsp.getResponseCode());
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001\uff1a\u672a\u77e5");
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001ResponseCode\uff1a" + rsp.getResponseCode());
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            Element head = JDomUtils.getChildElement((Element)hermes, (String)"Head");
            String dealCode = JDomUtils.getChildText((Element)head, (String)"DealCode");
            String content = JDomUtils.getChildText((Element)head, (String)"DealContent");
            infos.get(0).setBankRefKey(content);
            logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001dealCode\uff1a" + dealCode);
            if ("RET002".equals(dealCode) || "RET003".equals(dealCode) || "RET004".equals(dealCode) || "RET005".equals(dealCode)) {
                logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001\uff1a\u5931\u8d25");
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)dealCode, (String)content);
            } else {
                logger.info("\u66f4\u65b0\u7968\u636e\u72b6\u6001\uff1aSUBMITED");
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)dealCode, (String)content);
                infos.get(0).setRqstserialno(infos.get(0).getNoteStatus());
            }
        }
    }

    public static void parserNotePay(List<NotePayableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            Element head = JDomUtils.getChildElement((Element)hermes, (String)"Head");
            String dealCode = JDomUtils.getChildText((Element)head, (String)"DealCode");
            String content = JDomUtils.getChildText((Element)head, (String)"DealContent");
            if ("RET002".equals(dealCode) || "RET003".equals(dealCode) || "RET004".equals(dealCode) || "RET005".equals(dealCode)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)dealCode, (String)content);
            } else {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)dealCode, (String)content);
                infos.get(0).setRqstserialno(infos.get(0).getNoteStatus());
            }
        }
    }

    public static void parserNoteReqWithoutQueryPay(List<NotePayableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            Element head = JDomUtils.getChildElement((Element)hermes, (String)"Head");
            String dealCode = JDomUtils.getChildText((Element)head, (String)"DealCode");
            String content = JDomUtils.getChildText((Element)head, (String)"DealContent");
            if ("RET002".equals(dealCode) || "RET003".equals(dealCode) || "RET004".equals(dealCode) || "RET005".equals(dealCode)) {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)dealCode, (String)content);
            } else {
                EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)dealCode, (String)content);
            }
        } else {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
    }

    public static void parserNoteReqWithoutQuery(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if ("0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
            Element head = JDomUtils.getChildElement((Element)hermes, (String)"Head");
            String dealCode = JDomUtils.getChildText((Element)head, (String)"DealCode");
            String content = JDomUtils.getChildText((Element)head, (String)"DealContent");
            if ("RET002".equals(dealCode) || "RET003".equals(dealCode) || "RET004".equals(dealCode) || "RET005".equals(dealCode)) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)dealCode, (String)content);
            } else {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)dealCode, (String)content);
            }
        } else {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
    }

    public static Element packCmpElement(Element root, BankAcnt payAcnt) {
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(payAcnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)payAcnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)"01");
        return cmp;
    }
}

