/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DCNoteResponse;
import kd.ebg.note.banks.abc.dc.service.CommQueryParser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class QueryNoteStatusParser {
    public static void parseQueryPay(List<NoteReceivableInfo> infos, String rspStr, String[] successCodes, String[] failedCodes) {
        Map<String, ABC_DCNoteResponse> resultMap = CommQueryParser.parseQueryPayUseBillNo(infos, rspStr);
        for (NoteReceivableInfo info : infos) {
            ABC_DCNoteResponse response = resultMap.get(info.getBillNo());
            if (null == response) continue;
            String noteStatus = response.getNoteStatus();
            info.setNoteStatus(noteStatus);
            QueryNoteStatusParser.setSuccess(successCodes, info);
            QueryNoteStatusParser.setFailed(failedCodes, info);
            if (null != info.getStatus() && (PaymentState.SUCCESS.getId() == info.getStatus().intValue() || PaymentState.FAIL.getId() == info.getStatus().intValue())) {
                return;
            }
            String bakNoteStatus = info.getRqstserialno();
            if (!StringUtils.isEmpty((String)bakNoteStatus) && bakNoteStatus.equals(noteStatus)) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u88ab\u5bf9\u65b9\u62d2\u7edd\u6216\u56de\u9000\uff0c\u8be5\u64cd\u4f5c\u5931\u8d25\u3002", (String)"QueryNoteStatusParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\uff0c\u8bf7\u901a\u8fc7\u7968\u636e\u72b6\u6001\u6765\u67e5\u8bc1\u5f53\u524d\u64cd\u4f5c\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
                continue;
            }
            if (!QueryNoteStatusParser.isRejectSign(info)) continue;
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u62d2\u7edd\u7b7e\u6536\u64cd\u4f5c\u6210\u529f\u3002", (String)"QueryNoteStatusParser_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u6210\u529f\uff0c\u8bf7\u901a\u8fc7\u7968\u636e\u72b6\u6001\u6765\u67e5\u8bc1\u5f53\u524d\u64cd\u4f5c\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
    }

    private static void setFailed(String[] failedCodes, NotePayableInfo info) {
        if (null == failedCodes) {
            return;
        }
        for (String key : failedCodes) {
            String noteStatus = info.getNoteStatus();
            if (StringUtils.isEmpty((String)noteStatus) || !key.equals(noteStatus)) continue;
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u901a\u8fc7\u7968\u636e\u6821\u9a8c\uff0c\u7968\u636e\u4ea4\u6613\u5931\u8d25\u3002", (String)"QueryNoteStatusParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\u7968\u636e\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            break;
        }
    }

    private static void setFailed(String[] failedCodes, NoteReceivableInfo info) {
        if (null == failedCodes) {
            return;
        }
        for (String key : failedCodes) {
            String noteStatus = info.getNoteStatus();
            if (StringUtils.isEmpty((String)noteStatus) || !key.equals(noteStatus)) continue;
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u901a\u8fc7\u7968\u636e\u6821\u9a8c\uff0c\u7968\u636e\u4ea4\u6613\u5931\u8d25\u3002", (String)"QueryNoteStatusParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\u7968\u636e\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            break;
        }
    }

    private static void setSuccess(String[] successCodes, NotePayableInfo info) {
        if (null == successCodes) {
            return;
        }
        for (String key : successCodes) {
            String noteStatus = info.getNoteStatus();
            if (StringUtils.isEmpty((String)noteStatus) || !key.equals(noteStatus)) continue;
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u901a\u8fc7\u7968\u636e\u6821\u9a8c\uff0c\u7968\u636e\u4ea4\u6613\u6210\u529f\u3002", (String)"QueryNoteStatusParser_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u6210\u529f\u7968\u636e\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            break;
        }
    }

    private static void setSuccess(String[] successCodes, NoteReceivableInfo info) {
        if (null == successCodes) {
            return;
        }
        for (String key : successCodes) {
            String noteStatus = info.getNoteStatus();
            if (StringUtils.isEmpty((String)noteStatus) || !key.equals(noteStatus)) continue;
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u901a\u8fc7\u7968\u636e\u6821\u9a8c\uff0c\u7968\u636e\u4ea4\u6613\u6210\u529f\u3002", (String)"QueryNoteStatusParser_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u6210\u529f\u7968\u636e\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            break;
        }
    }

    public static boolean isRejectSign(NoteReceivableInfo info) {
        boolean flag = false;
        String rejectFlag = info.getOtherInfo();
        String subBizType = info.getSubBizType();
        if ("note_signin".equals(subBizType) && "SU01".equals(rejectFlag)) {
            flag = true;
        }
        return flag;
    }

    public static void parseQueryPayPay(List<NotePayableInfo> infos, String rspStr, String[] successCodes, String[] failedCodes) {
        Map<String, ABC_DCNoteResponse> resultMap = CommQueryParser.parseQueryPayUseBillNoPay(infos, rspStr);
        for (NotePayableInfo info : infos) {
            ABC_DCNoteResponse response = resultMap.get(info.getBillNo());
            if (null == response) continue;
            String noteStatus = response.getNoteStatus();
            info.setNoteStatus(noteStatus);
            QueryNoteStatusParser.setSuccess(successCodes, info);
            QueryNoteStatusParser.setFailed(failedCodes, info);
            if (null != info.getStatus() && (PaymentState.SUCCESS.getId() == info.getStatus().intValue() || PaymentState.FAIL.getId() == info.getStatus().intValue())) {
                return;
            }
            String bakNoteStatus = info.getRqstserialno();
            if (StringUtils.isEmpty((String)bakNoteStatus) || !bakNoteStatus.equals(noteStatus)) continue;
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u88ab\u5bf9\u65b9\u62d2\u7edd\u6216\u56de\u9000\uff0c\u8be5\u64cd\u4f5c\u5931\u8d25\u3002", (String)"QueryNoteStatusParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u5931\u8d25\uff0c\u8bf7\u901a\u8fc7\u7968\u636e\u72b6\u6001\u6765\u67e5\u8bc1\u5f53\u524d\u64cd\u4f5c\u72b6\u6001\u3002", (String)"QueryNoteStatusParser_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
    }
}

